<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Account_transactions extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('account_transactions_model','accounts');
	}
	
	public function get_sales_code($salespayment_id){
		if (empty($salespayment_id)) { return ''; }
		return $this->db->select("a.sales_code,a.id")
						->from("db_sales a")
						->from("db_salespayments b")
						->where("a.id=b.sales_id")
						->where("b.id=", $salespayment_id)->get()->row();
	}
	public function get_sales_return_code($returnpayment_id){
		if (empty($returnpayment_id)) { return ''; }
		return $this->db->select("a.return_code,a.id")
						->from("db_salesreturn a")
						->from("db_salespaymentsreturn b")
						->where("a.id=b.return_id")
						->where("b.id=", $returnpayment_id)->get()->row();
	}
	public function get_purchase_code($purchasepayment_id){
		if (empty($purchasepayment_id)) { return ''; }
		return $this->db->select("a.purchase_code,a.id")
						->from("db_purchase a")
						->from("db_purchasepayments b")
						->where("a.id=b.purchase_id")
						->where("b.id=", $purchasepayment_id)->get()->row();
	}
	public function get_purchase_return_code($returnpayment_id){
		if (empty($returnpayment_id)) { return ''; }
		return $this->db->select("a.return_code,a.id")
						->from("db_purchasereturn a")
						->from("db_purchasepaymentsreturn b")
						->where("a.id=b.return_id")
						->where("b.id=", $returnpayment_id)->get()->row();
	}
	public function get_expense_code($expense_id){
		if (empty($expense_id)) { return ''; }
		return $this->db->select("a.expense_code,a.id")
						->from("db_expense a")
						->where("a.id=", $expense_id)->get()->row();
	}

	public function ajax_list()
	{
		// Clear any previous output
		if (ob_get_level()) { ob_clean(); }

		// Set content type to JSON
		header('Content-Type: application/json');

		// Disable error display (avoid breaking JSON)
		error_reporting(0);
		ini_set('display_errors', 0);

		// Start output buffering to catch any unexpected output
		ob_start();

		try {
			// ---- SAFE FETCH OF DATATABLES PARAMS (allow 0 values like start=0) ----
			$draw_raw   = $this->input->post('draw',   true);
			$start_raw  = $this->input->post('start',  true);
			$length_raw = $this->input->post('length', true);

			// Fallback to GET if your DT is configured that way
			if ($draw_raw   === null) $draw_raw   = $this->input->get('draw',   true);
			if ($start_raw  === null) $start_raw  = $this->input->get('start',  true);
			if ($length_raw === null) $length_raw = $this->input->get('length', true);

			if ($draw_raw === null || $start_raw === null || $length_raw === null) {
				throw new Exception(
					'Missing required POST parameters: draw=' . var_export($draw_raw, true) .
					', start='  . var_export($start_raw, true) .
					', length=' . var_export($length_raw, true)
				);
			}

			$draw   = (int)$draw_raw;
			$start  = (int)$start_raw;
			$length = (int)$length_raw;
			if ($length < -1) { $length = 10; }

			// Log the request for debugging
			log_message('debug', 'Account Transactions AJAX Request - Account ID: ' . $this->input->post('account_id'));
			log_message('debug', 'Account Transactions AJAX Request - POST data: ' . json_encode($_POST));

			// Test basic query first
			$this->db->select('COUNT(*) as count');
			$this->db->from('ac_transactions a');
			$this->db->where('a.store_id', get_current_store_id());
			$test_query = $this->db->get();
			$test_result = $test_query->row();
			log_message('debug', 'Basic query test - Total transactions: ' . ($test_result ? $test_result->count : 'No result'));

			$list = $this->accounts->get_datatables(); // keep your existing model call
			log_message('debug', 'Account Transactions Query successful - Records: ' . (is_array($list) ? count($list) : 0));

		} catch (Exception $e) {
			log_message('error', 'Account Transactions AJAX Error: ' . $e->getMessage());
			log_message('error', 'Account Transactions AJAX Error File: ' . $e->getFile() . ' Line: ' . $e->getLine());

			// Clear any buffered output
			ob_clean();

			$output = array(
				"draw" => isset($draw) ? (int)$draw : 0,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => array(),
				"error" => "Error loading data: " . $e->getMessage()
			);
			echo json_encode($output);
			return;
		}

		$data = array();
		$no = $start;

		// ------- Previous balance (up to the selected from_date) -------
		$prev_balance = 0;
		$prev_base_balance = 0;
		$account_id = $this->input->post('account_id');
		$from_date  = $this->input->post('from_date');
		$from_date  = system_fromatted_date($from_date);

		if (!empty($account_id) && $from_date != '1970-01-01') {
			$store_id = get_current_store_id();

			// Sum credits to this account before from_date
			$credit_amt = $this->db->select("COALESCE(SUM(a.credit_amt),0) AS credit_amt", false)
				->from("ac_transactions a")
				->where("a.credit_account_id", $account_id)
				->where("a.transaction_date <", $from_date)
				->where("a.store_id", $store_id)
				->get()->row()->credit_amt;

			// Sum debits from this account before from_date
			$debit_amt = $this->db->select("COALESCE(SUM(a.debit_amt),0) AS debit_amt", false)
				->from("ac_transactions a")
				->where("a.debit_account_id", $account_id)
				->where("a.transaction_date <", $from_date)
				->where("a.store_id", $store_id)
				->get()->row()->debit_amt;

			$prev_balance = $credit_amt - $debit_amt;
		}

		if (!is_array($list)) { $list = array(); }

		// Get account currency for proper display
		$account_currency_info = $this->db->select('a.currency_id, c.currency_name, c.currency_code, c.symbol')
			->from('ac_accounts a')
			->join('db_currency c', 'a.currency_id = c.id', 'left')
			->where('a.id', $account_id)
			->get()->row();
		
		$account_currency_id = $account_currency_info ? $account_currency_info->currency_id : get_base_currency()->id;

		foreach ($list as $accounts) {
			$no++;
			$row = array();

			$row[] = show_date($accounts->transaction_date);

			$account_cr_dr = ($account_id == $accounts->debit_account_id) ? 'Debit_entry' : 'Credit_entry';

			$description = ucwords(strtolower($accounts->transaction_type));
			$description = "<b>".$description."</b>";

			// CUSTOMER OR ACCOUNT (links/extras)
			$from_ = '';
			$to_   = '';
			if ($accounts->transaction_type != 'OPENING BALANCE PAID') {
				if (!empty($accounts->supplier_id)) {
					if (!empty($accounts->ref_purchasepayments_id)) {
						$query = $this->get_purchase_code($accounts->ref_purchasepayments_id);
						if ($query) {
							$purchase_code = $query->purchase_code;
							$purchase_id   = $query->id;
							$from_ = "<a data-toggle='tooltip' title='View Purchase Payments' href='".base_url('purchase/invoice/').$purchase_id."'>".$purchase_code."</a>";
						}
					} else if (!empty($accounts->ref_purchasepaymentsreturn_id)) {
						$query = $this->get_purchase_return_code($accounts->ref_purchasepaymentsreturn_id);
						if ($query) {
							$return_code = $query->return_code;
							$return_id   = $query->id;
							$from_ = "<a data-toggle='tooltip' title='View Purchase Return Payments' href='".base_url('purchase_return/invoice/').$return_id."'>".$return_code."</a>";
						}
					}
				}
				else if (!empty($accounts->customer_id)) {
					if (!empty($accounts->ref_salespayments_id)) {
						$query = $this->get_sales_code($accounts->ref_salespayments_id);
						if ($query) {
							$sales_code = $query->sales_code;
							$sales_id   = $query->id;
							$from_ = "<a data-toggle='tooltip' title='View Sales Payments' href='".base_url('sales/invoice/').$sales_id."'>".$sales_code."</a>";
						}
					} else if (!empty($accounts->ref_salespaymentsreturn_id)) {
						$query = $this->get_sales_return_code($accounts->ref_salespaymentsreturn_id);
						if ($query) {
							$return_code = $query->return_code;
							$return_id   = $query->id;
							$from_ = "<a data-toggle='tooltip' title='View Sales Return Payments' href='".base_url('sales_return/invoice/').$return_id."'>".$return_code."</a>";
						}
					}
				}
				else {
					$from_ = get_account_name($accounts->debit_account_id);
				}

				if (!empty($accounts->supplier_id)) {
					if (!empty($accounts->ref_purchasepayments_id)) {
						$query = $this->get_purchase_code($accounts->ref_purchasepayments_id);
						if ($query) {
							$purchase_code = $query->purchase_code;
							$purchase_id   = $query->id;
							$to_ = "<a data-toggle='tooltip' title='View Purchase Payments' href='".base_url('purchase/invoice/').$purchase_id."'>".$purchase_code."</a>";
						}
					} else if (!empty($accounts->ref_purchasepaymentsreturn_id)) {
						$query = $this->get_purchase_return_code($accounts->ref_purchasepaymentsreturn_id);
						if ($query) {
							$return_code = $query->return_code;
							$return_id   = $query->id;
							$to_ = "<a data-toggle='tooltip' title='View Purchase Return Payments' href='".base_url('purchase_return/invoice/').$return_id."'>".$return_code."</a>";
						}
					}
				}
				else if (!empty($accounts->customer_id)) {
					if (!empty($accounts->ref_salespayments_id)) {
						$query = $this->get_sales_code($accounts->ref_salespayments_id);
						if ($query) {
							$sales_code = $query->sales_code;
							$sales_id   = $query->id;
							$to_ = "<a data-toggle='tooltip' title='View Sales Payments' href='".base_url('sales/invoice/').$sales_id."'>".$sales_code."</a>";
						}
					} else if (!empty($accounts->ref_salespaymentsreturn_id)) {
						$query = $this->get_sales_return_code($accounts->ref_salespaymentsreturn_id);
						if ($query) {
							$return_code = $query->return_code;
							$return_id   = $query->id;
							$to_ = "<a data-toggle='tooltip' title='View Sales Return Payments' href='".base_url('sales_return/invoice/').$return_id."'>".$return_code."</a>";
						}
					}
				}
				else if (!empty($accounts->ref_expense_id)) {
					$query = $this->get_expense_code($accounts->ref_expense_id);
					if ($query) {
						$expense_code = $query->expense_code;
						$expense_id   = $accounts->ref_expense_id;
						$to_ = "<a data-toggle='tooltip' title='View Expense Details' href='".base_url('expense/update/').$expense_id."'>".$expense_code."</a>";
					}
				}
				else {
					$to_ = get_account_name($accounts->credit_account_id);
				}

				$description_ext =
					($account_cr_dr=='Debit_entry')
						? ('[To: ' . $to_ . ']')
						: ((!empty($from_)) ? ('[From: ' . $from_ . ']') : '');

				$description = ($accounts->transaction_type!='OPENING BALANCE') ? ($description."<br>".$description_ext) : $description;
			}
			$row[] = $description;

			// Display amounts with account currency first and system currency in parentheses
			$base_currency = get_base_currency();
			if ($account_currency_id == $base_currency->id) {
				// Same currency, just show the amount
				$debit_amt_display  = ($account_cr_dr == 'Debit_entry')  ? format_currency_amount($accounts->debit_amt, $account_currency_id)  : '';
				$credit_amt_display = ($account_cr_dr == 'Credit_entry') ? format_currency_amount($accounts->credit_amt, $account_currency_id) : '';
			} else {
				// Different currencies, show account currency with base currency in parentheses
				if ($account_cr_dr == 'Debit_entry') {
					// Check if this is an old transaction where amounts were stored in base currency
					// If base_currency_debit_amt is empty/zero and the amount seems too small, 
					// it might be stored in base currency instead of account currency
					$stored_amount = $accounts->debit_amt;
					$base_amount = $accounts->base_currency_debit_amt;
					
					// For expense transactions, always try to use the original expense amount
					if ($accounts->transaction_type == 'EXPENSE PAYMENT' && $accounts->ref_expense_id) {
						// Get the original expense amount
						$expense_info = $this->db->select('expense_amt, expense_currency_id')
							->where('id', $accounts->ref_expense_id)
							->get('db_expense')->row();
						
						if ($expense_info) {
							// Use the original expense amount
							$stored_amount = $expense_info->expense_amt;
							// Convert to base currency for display
							$base_amount = convert_currency($stored_amount, $expense_info->expense_currency_id, $base_currency->id);
						} else {
							// Fallback: calculate base currency amount from stored amount
							$base_amount = convert_currency($stored_amount, $account_currency_id, $base_currency->id);
						}
					} else {
						// For non-expense transactions, use stored amounts
						if (empty($base_amount) || $base_amount == 0) {
							$base_amount = convert_currency($stored_amount, $account_currency_id, $base_currency->id);
						}
					}
					
					$account_display = format_currency_amount($stored_amount, $account_currency_id);
					$base_display = format_currency_amount($base_amount, $base_currency->id);
					$debit_amt_display = $account_display . ' ( ' . $base_display . ' )';
				} else {
					$debit_amt_display = '';
				}
				
				if ($account_cr_dr == 'Credit_entry') {
					// Similar logic for credit amounts
					$stored_amount = $accounts->credit_amt;
					$base_amount = $accounts->base_currency_credit_amt;
					
					if (empty($base_amount) || $base_amount == 0) {
						$base_amount = convert_currency($stored_amount, $account_currency_id, $base_currency->id);
					}
					
					$account_display = format_currency_amount($stored_amount, $account_currency_id);
					$base_display = format_currency_amount($base_amount, $base_currency->id);
					$credit_amt_display = $account_display . ' ( ' . $base_display . ' )';
				} else {
					$credit_amt_display = '';
				}
			}
			$row[] = $debit_amt_display;
			$row[] = $credit_amt_display;

			// Balance calc (use corrected amounts for expense transactions)
			$balance_amount = ($account_cr_dr=='Debit_entry') ? $accounts->debit_amt : $accounts->credit_amt;
			
			// For expense transactions, use the original expense amount
			if ($accounts->transaction_type == 'EXPENSE PAYMENT' && $accounts->ref_expense_id && $account_cr_dr == 'Debit_entry') {
				$expense_info = $this->db->select('expense_amt, expense_currency_id')
					->where('id', $accounts->ref_expense_id)
					->get('db_expense')->row();
				
				if ($expense_info) {
					// Convert expense amount to account currency for balance calculation
					if ($expense_info->expense_currency_id == $account_currency_id) {
						$balance_amount = $expense_info->expense_amt;
					} else {
						$balance_amount = convert_currency($expense_info->expense_amt, $expense_info->expense_currency_id, $account_currency_id);
					}
				}
			}
			
			$balance = ($account_cr_dr=='Debit_entry') ? (0 - $balance_amount) : ($balance_amount - 0);
			$prev_balance += $balance;
			
			// Format running balance
			if ($account_currency_id == $base_currency->id) {
				$row[] = format_currency_amount($prev_balance, $account_currency_id);
			} else {
				// Calculate base currency running balance
				$base_balance = 0;
				if ($account_cr_dr=='Debit_entry') {
					$base_balance = (0 - $accounts->base_currency_debit_amt);
					// If stored base currency amount is empty or 0, calculate it
					if (empty($accounts->base_currency_debit_amt) || $accounts->base_currency_debit_amt == 0) {
						$base_balance = (0 - convert_currency($accounts->debit_amt, $account_currency_id, $base_currency->id));
					}
				} else {
					$base_balance = ($accounts->base_currency_credit_amt - 0);
					// If stored base currency amount is empty or 0, calculate it
					if (empty($accounts->base_currency_credit_amt) || $accounts->base_currency_credit_amt == 0) {
						$base_balance = (convert_currency($accounts->credit_amt, $account_currency_id, $base_currency->id) - 0);
					}
				}
				$prev_base_balance += $base_balance;
				
				$account_display = format_currency_amount($prev_balance, $account_currency_id);
				$base_display = format_currency_amount($prev_base_balance, $base_currency->id);
				$row[] = $account_display . ' ( ' . $base_display . ' )';
			}

			$row[] = $accounts->note;
			$row[] = ($accounts->created_by);

			$link=''; $title=''; $entry_of=''; $record_id='';

			if ($accounts->ref_moneytransfer_id) {
				$link = "money_transfer/update/".$accounts->ref_moneytransfer_id;
				$title = 'Edit Transfer Entry';
				$entry_of = 1;
				$record_id = $accounts->ref_moneytransfer_id;
			}
			else if ($accounts->ref_moneydeposits_id) {
				$link = "money_deposit/update/".$accounts->ref_moneydeposits_id;
				$title = 'Edit Deposit Entry';
				$entry_of = 2;
				$record_id = $accounts->ref_moneydeposits_id;
			}
			else if ($accounts->ref_salespayments_id) {
				$link = "";
				$title = '';
				$entry_of = 3;
				$record_id = $accounts->ref_salespayments_id;
			}
			else if ($accounts->ref_salespaymentsreturn_id) {
				$link = "";
				$title = '';
				$entry_of = 4;
				$record_id = $accounts->ref_salespaymentsreturn_id;
			}
			else if ($accounts->ref_purchasepayments_id) {
				$link = "";
				$title = '';
				$entry_of = 5;
				$record_id = $accounts->ref_purchasepayments_id;
			}
			else if ($accounts->ref_purchasepaymentsreturn_id) {
				$link = "";
				$title = '';
				$entry_of = 6;
				$record_id = $accounts->ref_purchasepaymentsreturn_id;
			}
			else if ($accounts->ref_expense_id) {
				$link = "";
				$title = '';
				$entry_of = 7;
				$record_id = $accounts->ref_expense_id;
			}

			$str2 = '<div class="btn-group" title="View Account">
						<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
							Action <span class="caret"></span>
						</a>
						<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

			if ($this->permissions('accounts_delete'))
				$str2 .= '<li>
							<a style="cursor:pointer" title="Delete Record ?" onclick="delete_transaction('.$record_id.','.$entry_of.')">
								<i class="fa fa-fw fa-trash text-red"></i>Delete
							</a>
						  </li>';

			$str2 .=    '</ul>
					</div>';

			$row[] = ($accounts->transaction_type!='OPENING BALANCE') ? $str2 : '';

			$data[] = $row;
		}

		try {
			// Clear any buffered output before JSON response
			ob_clean();

			$output = array(
				"draw"            => (int)$draw,
				"recordsTotal"    => $this->accounts->count_all(),
				"recordsFiltered" => $this->accounts->count_filtered(),
				"data"            => $data,
			);
			echo json_encode($output);
		} catch (Exception $e) {
			log_message('error', 'Account Transactions JSON Output Error: ' . $e->getMessage());
			ob_clean();
			$error_output = array(
				"draw" => (int)$draw,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => array(),
				"error" => "Error generating response: " . $e->getMessage()
			);
			echo json_encode($error_output);
		}
	}

	public function test_json()
	{
		if (ob_get_level()) { ob_clean(); }
		header('Content-Type: application/json');

		$test_data = array(
			"draw" => 1,
			"recordsTotal" => 0,
			"recordsFiltered" => 0,
			"data" => array(),
			"test" => "JSON response working"
		);
		echo json_encode($test_data);
	}
	
	public function debug_db()
	{
		if (ob_get_level()) { ob_clean(); }
		header('Content-Type: application/json');

		try {
			$store_id = get_current_store_id();
			$test_query = $this->db->select('COUNT(*) as count')->from('ac_transactions a')->where('a.store_id', $store_id)->get();
			$test_result = $test_query->row();

			$debug_data = array(
				"draw" => 1,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => array(),
				"debug" => array(
					"store_id" => $store_id,
					"transaction_count" => $test_result ? $test_result->count : 'No result',
					"db_connected" => $this->db->conn_id ? 'Yes' : 'No',
					"test_time" => date('Y-m-d H:i:s')
				)
			);
			echo json_encode($debug_data);
		} catch (Exception $e) {
			$error_data = array(
				"draw" => 1,
				"recordsTotal" => 0,
				"recordsFiltered" => 0,
				"data" => array(),
				"error" => "Database error: " . $e->getMessage()
			);
			echo json_encode($error_data);
		}
	}

	public function delete_transaction(){
		$entry_of = $this->input->post('entry_of');
		$this->permission_check_with_msg('accounts_delete');
		$id = $this->input->post('q_id');

		if ($entry_of==1){ // transfer
			$this->load->model('money_transfer_model');
			echo $this->money_transfer_model->delete_money_transfer_from_table($id);
		}
		else if ($entry_of==2){ // deposit
			$this->load->model('money_deposit_model');
			echo $this->money_deposit_model->delete_money_deposit_from_table($id);
		}
		else if ($entry_of==3){ // sales payments
			$this->load->model('sales_model');
			echo $this->sales_model->delete_payment($id);
		}
		else if ($entry_of==4){ // sales return payments
			$this->load->model('sales_return_model');
			echo $this->sales_return_model->delete_payment($id);
		}
		else if ($entry_of==5){ // purchase payments
			$this->load->model('purchase_model');
			echo $this->purchase_model->delete_payment($id);
		}
		else if ($entry_of==6){ // purchase return payments
			$this->load->model('purchase_returns_model');
			echo $this->purchase_returns_model->delete_payment($id);
		}
		else if ($entry_of==7){ // expenses
			$this->load->model('expense_model');
			echo $this->expense_model->delete_expenses_from_table($id);
		}
	}
}
