<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Currency extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('currency_model','currency');
	}

	public function add(){
		//$this->permission_check('currency_add');
		if(!special_access()){
			$this->show_access_denied_page();exit;
		}
		$data=$this->data;
		$data['page_title']=$this->lang->line('currency');
		$this->load->view('currency', $data);
	}
	public function newcurrency(){
		//$this->permission_check('currency_add');
		if(!special_access()){
			$this->show_access_denied_page();exit;
		}
		$this->form_validation->set_rules('currency_code', 'Currency Code', 'trim|required');
		$this->form_validation->set_rules('currency_name', 'Currency Name', 'trim|required');
		$this->form_validation->set_rules('currency', 'Currency Symbol', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			$this->load->model('currency_model');
			$result=$this->currency_model->verify_and_save();
			if($result==true){
				$this->session->set_flashdata('success_message', $this->lang->line('added_successfully'));
				redirect('currency/view');
			}
			else{
				$this->session->set_flashdata('error_message', $this->lang->line('error_in_adding_record'));
				redirect('currency/view');
			}
		}
		else{
			$this->add();
		}
	}
	public function update($id){
		//$this->permission_check('currency_edit');
		if(!special_access()){
			$this->show_access_denied_page();exit;
		}
		$data=$this->data;
		$data['page_title']=$this->lang->line('currency');
		$data['currency']=$this->currency->get_details($id,$data);
		$this->load->view('currency', $data);
	}
	public function update_currency(){
		//$this->permission_check('currency_edit');
		if(!special_access()){
			$this->show_access_denied_page();exit;
		}
		$this->form_validation->set_rules('currency_code', 'Currency Code', 'trim|required');
		$this->form_validation->set_rules('currency_name', 'Currency Name', 'trim|required');
		$this->form_validation->set_rules('currency', 'Currency Symbol', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$this->load->model('currency_model');
			$result=$this->currency_model->update_currency();
			if($result==true){
				$this->session->set_flashdata('success_message', $this->lang->line('updated_successfully'));
				redirect('currency/view');
			}
			else{
				$this->session->set_flashdata('error_message', $this->lang->line('error_in_updating_record'));
				redirect('currency/view');
			}
		}
		else{
			$this->update($this->input->post('q_id'));
		}
	}
	public function view(){
		//$this->permission_check('currency_view');
		if(!special_access()){
			$this->show_access_denied_page();exit;
		}
		$data=$this->data;
		$data['page_title']=$this->lang->line('currencies_list');
		$this->load->view('currency-view', $data);
	}

	public function ajax_list()
	{
		$list = $this->currency->get_datatables();
		
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $currency) {
			$no++;
			$row = array();
			$row[] = '<input type="checkbox" name="checkbox[]" value='.$currency->id.' class="checkbox column_checkbox" disabled>';
			$row[] = $currency->currency_name;
			$row[] = $currency->currency_code;
			$row[] = $currency->currency_symbol;
			
			// Status column with proper formatting
			if($currency->status==1){ 
				$str= "<span onclick='update_status(".$currency->id.",0)' id='span_".$currency->id."'  class='label label-success' style='cursor:pointer'>Active </span>";
			} else { 
				$str = "<span onclick='update_status(".$currency->id.",1)' id='span_".$currency->id."'  class='label label-danger' style='cursor:pointer'> Inactive </span>";
			}
			$row[] = $str;

			// Action column - only Edit button, no delete
			$str2 = '<div class="btn-group" title="View Currency">
						<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
							Action <span class="caret"></span>
						</a>
						<ul role="menu" class="dropdown-menu dropdown-light pull-right">
							<li>
								<a title="Edit Record ?" href="'.base_url().'currency/update/'.$currency->id.'">
									<i class="fa fa-fw fa-edit text-blue"></i>Edit
								</a>
							</li>
						</ul>
					</div>';
			$row[] = $str2;
			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->currency->count_all(),
						"recordsFiltered" => $this->currency->count_filtered(),
						"data" => $data,
				);
		echo json_encode($output);
	}

	public function update_status(){
		//$this->permission_check_with_msg('currency_edit');
		if(!special_access()){
			$this->show_access_denied_page();exit;
		}
		$id=$this->input->post('id');
		$status=$this->input->post('status');

		$result=$this->currency->update_status($id,$status);
		if($result==true){
			echo "success";
		}
		else{
			echo "failed";
		}
	}
	public function delete_currencies(){
		//$this->permission_check_with_msg('currency_delete');
		if(!special_access()){
			$this->show_access_denied_page();exit;
		}
		$id=$this->input->post('id');
		$result=$this->currency->delete_currencies_from_table($id);
		if($result==true){
			echo "success";
		}
		else{
			echo "failed";
		}
	}
	
	public function get_currency_info()
	{
		$currency_id = $this->input->post('currency_id');
		
		if (empty($currency_id)) {
			echo json_encode(array('success' => false, 'message' => 'Currency ID is required'));
			return;
		}
		
		$this->db->select('currency_name, currency_code, symbol');
		$this->db->from('db_currency');
		$this->db->where('id', $currency_id);
		$this->db->where('status', 1);
		$query = $this->db->get();
		
		if ($query->num_rows() > 0) {
			$currency = $query->row();
			echo json_encode(array(
				'success' => true,
				'currency_name' => $currency->currency_name,
				'currency_code' => $currency->currency_code,
				'symbol' => $currency->symbol
			));
		} else {
			echo json_encode(array('success' => false, 'message' => 'Currency not found'));
		}
	}
	
	public function get_exchange_rate()
	{
		$from_currency = $this->input->post('from_currency');
		$to_currency = $this->input->post('to_currency');
		$amount = $this->input->post('amount');
		
		if (empty($from_currency) || empty($to_currency)) {
			echo json_encode(array('success' => false, 'message' => 'Currency parameters are required'));
			return;
		}
		
		// Get exchange rate
		$exchange_rate = get_exchange_rate($from_currency, $to_currency);
		
		if ($exchange_rate === false) {
			echo json_encode(array(
				'success' => false,
				'message' => 'Exchange rate not available',
				'exchange_rate' => false,
				'base_amount' => 0,
				'original_amount' => $amount
			));
			return;
		}
		
		$base_amount = $amount * $exchange_rate;
		
		echo json_encode(array(
			'success' => true,
			'exchange_rate' => $exchange_rate,
			'base_amount' => $base_amount,
			'original_amount' => $amount
		));
	}
	
	public function get_currency_list()
	{
		$this->db->select('id, currency_name, currency_code, symbol, is_base_currency');
		$this->db->from('db_currency');
		$this->db->where('status', 1);
		$this->db->order_by('is_base_currency DESC, currency_name ASC');
		$query = $this->db->get();
		
		$currencies = $query->result();
		
		echo json_encode(array(
			'success' => true,
			'currencies' => $currencies
		));
	}
}