<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Expense extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('expense_model','expense');
		$this->load->model('expense_category_model','category');
	}
	/* ######################################## EXPENSE START ############################# */
	public function index()
	{
		$this->permission_check('expense_view');
		$data=$this->data;
		$data['page_title']=$this->lang->line('expenses_list');
		$this->load->view('expense-list',$data);
	}
	public function add()
	{
		$this->permission_check('expense_add');
		$data=$this->data;
		$data['page_title']=$this->lang->line('expenses');
		$this->load->view('expense',$data);
	}
	
	
	public function newexpense(){
		$this->form_validation->set_rules('expense_date', 'Expense Date', 'trim|required');
		$this->form_validation->set_rules('category_id', 'Category Name', 'trim|required');
		$this->form_validation->set_rules('expense_amt', 'Expense Amount', 'trim|required');
		$this->form_validation->set_rules('expense_for', 'Expense for', 'trim|required');
		$this->form_validation->set_rules('payment_type', 'Payment Type', 'trim|required');
		$this->form_validation->set_rules('account_id', 'Account', 'trim|required');
		$this->form_validation->set_rules('expense_currency_id', 'Currency', 'trim|required');

		
		if ($this->form_validation->run() == TRUE) {
			$result=$this->expense->verify_and_save();
			echo $result;
		} else {
			echo "Please Fill Compulsory(* marked) Fields.";
		}
	}
	public function update($id){
		$this->belong_to('db_expense',$id);
		$this->permission_check('expense_edit');
		$data=$this->data;
		$result=$this->expense->get_details($id,$data);
		$data=array_merge($data,$result);
		$data['page_title']=$this->lang->line('expenses');
		$this->load->view('expense', $data);
	}
	public function update_expense(){
		$this->form_validation->set_rules('expense_date', 'Expense Date', 'trim|required');
		$this->form_validation->set_rules('category_id', 'Category Name', 'trim|required');
		$this->form_validation->set_rules('expense_amt', 'Expense Amount', 'trim|required');
		$this->form_validation->set_rules('expense_for', 'Expense for', 'trim|required');
		$this->form_validation->set_rules('payment_type', 'Payment Type', 'trim|required');
		$this->form_validation->set_rules('account_id', 'Account', 'trim|required');
		$this->form_validation->set_rules('expense_currency_id', 'Currency', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$result=$this->expense->update_expense();
			echo $result;
		} else {
			echo "Please Fill Compulsory(* marked) Fields.";
		}
	}

	public function ajax_list()
	{
		$list = $this->expense->get_datatables();
		
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $expense) {
			$no++;
			$row = array();
			$row[] = '<input type="checkbox" name="checkbox[]" value='.$expense->id.' class="checkbox column_checkbox" >';
			$row[] = show_date($expense->expense_date);
			$row[] = $expense->category_name;
			$row[] = $expense->reference_no;
			$row[] = $expense->expense_for;
			
			// Display amount with proper currency formatting
			$expense_currency_id = $expense->expense_currency_id ?: get_base_currency()->id;
			$amount_display = format_currency_with_system($expense->expense_amt, $expense_currency_id);
			$row[] = $amount_display;
			
			$row[] = get_account_name($expense->account_id);			
			$row[] = $expense->note;			
			$row[] = ($expense->created_by);			
				     $str2 = '<div class="btn-group" title="View Account">
									<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
										Action <span class="caret"></span>
									</a>
									<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

											if($this->permissions('expense_edit'))
											$str2.='<li>
												<a title="Edit Record ?" href="'.base_url().'expense/update/'.$expense->id.'">
													<i class="fa fa-fw fa-edit text-blue"></i>Edit
												</a>
											</li>';

											if($this->permissions('expense_view'))
											$str2.='<li>
												<a title="Print Receipt ?" href="'.base_url().'expense/receipt/'.$expense->id.'" target="_blank">
													<i class="fa fa-fw fa-print text-green"></i>Print Receipt
												</a>
											</li>';

											if($this->permissions('expense_delete'))
											$str2.='<li>
												<a style="cursor:pointer" title="Delete Record ?" onclick="delete_expense('.$expense->id.')">
													<i class="fa fa-fw fa-trash text-red"></i>Delete
												</a>
											</li>
											
										</ul>
									</div>';			
			$row[] = $str2;

			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->expense->count_all(),
						"recordsFiltered" => $this->expense->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}
	public function update_status(){
		$this->permission_check_with_msg('expense_edit');
		$id=$this->input->post('id');
		$status=$this->input->post('status');
		return $this->expense->update_status($id,$status);
		
	}
	public function delete_expense(){
		$this->permission_check_with_msg('expense_delete');
		$id=$this->input->post('q_id');
		echo $this->expense->delete_expenses_from_table($id);
	}
	public function multi_delete_expense(){
		$this->permission_check_with_msg('expense_delete');
		$ids=implode (",",$_POST['checkbox']);
		echo $this->expense->delete_expenses_from_table($ids);
	}
	
	/* ######################################## EXPENSE END ############################# */





	/* ######################################## EXPENSE CATEGORY START ############################# */
	public function category()
	{	
		$this->permission_check('expense_category_view');
		$data=$this->data;
		$data['page_title']=$this->lang->line('expense_category_list');
		$this->load->view('expense-category-list',$data);
	}
	public function category_add()
	{
		$this->permission_check('expense_category_add');
		$data=$this->data;
		$data['page_title']=$this->lang->line('expense_category');
		$this->load->view('expense-category',$data);
	}
	public function newcategory(){
		$this->form_validation->set_rules('category', 'Category', 'trim|required');
		if ($this->form_validation->run() == TRUE) {
			$this->load->model('expense_category_model');
			$result=$this->expense_category_model->verify_and_save();
			echo $result;
		} else {
			echo "Please Enter Category name.";
		}
	}
	public function ajax_list_expense()
	{
		
		$list = $this->category->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $category) {
			$no++;
			$row = array();
			$row[] = '<input type="checkbox" name="checkbox[]" value='.$category->id.' class="checkbox column_checkbox" >';
			
			$row[] = $category->category_name;
			$row[] = $category->description;

			 		if($category->status==1){ 
			 			$str= "<span onclick='update_status(".$category->id.",0)' id='span_".$category->id."'  class='label label-success' style='cursor:pointer'>Active </span>";}
					else{ 
						$str = "<span onclick='update_status(".$category->id.",1)' id='span_".$category->id."'  class='label label-danger' style='cursor:pointer'> Inactive </span>";
					}
			$row[] = $str;			
					 $str2 = '<div class="btn-group" title="View Account">
										<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
											Action <span class="caret"></span>
										</a>
										<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

											if($this->permissions('expense_category_edit'))
											$str2.='<li>
												<a title="Edit Record ?" href="expense_update/'.$category->id.'">
													<i class="fa fa-fw fa-edit text-blue"></i>Edit
												</a>
											</li>';

											if($this->permissions('expense_category_delete'))
											$str2.='<li>
												<a style="cursor:pointer" title="Delete Record ?" onclick="delete_category('.$category->id.')">
													<i class="fa fa-fw fa-trash text-red"></i>Delete
												</a>
											</li>
											
										</ul>
									</div>';			

			$row[] = $str2;
			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->category->count_all(),
						"recordsFiltered" => $this->category->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}
	public function expense_update($id){
		$this->belong_to('db_expense_category',$id);
		$this->permission_check_with_msg('expense_category_edit');
		$data=$this->data;		
		$result=$this->category->get_details($id,$data);
		$data=array_merge($data,$result);
		$data['page_title']=$this->lang->line('expense_category');
		$this->load->view('expense-category', $data);
	}
	public function update_category(){
		$this->form_validation->set_rules('category', 'Category', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$result=$this->category->update_category();
			echo $result;
		} else {
			echo "Please Enter Category name.";
		}
	}

	public function expense_update_status(){
		$this->permission_check_with_msg('expense_category_edit');
		$id=$this->input->post('id');
		$status=$this->input->post('status');
		return $this->category->update_status($id,$status);
		
	}
	public function delete_category(){
		$this->permission_check_with_msg('expense_category_delete');
		$id=$this->input->post('q_id');
		return $this->category->delete_categories_from_table($id);
	}
	public function multi_delete(){
		$this->permission_check_with_msg('expense_category_delete');
		$ids=implode (",",$_POST['checkbox']);
		return $this->category->delete_categories_from_table($ids);
	}
	public function get_expense_category_select_list(){
		echo get_expense_category_select_list(null,$_POST['store_id']);
	}
	
	// Display expense receipt
	public function receipt($id) {
		$this->permission_check('expense_view');
		
		// Get expense details
		$expense = $this->db->select('e.*, c.category_name, cu.currency_name, cu.currency_code, cu.symbol as currency_symbol, cu.symbol as currency_symbol')
							->from('db_expense e')
							->join('db_expense_category c', 'c.id = e.category_id', 'left')
							->join('db_currency cu', 'cu.id = e.expense_currency_id', 'left')
							->where('e.id', $id)
							->get()->row();
		
		if (!$expense) {
			show_404();
			return;
		}
		
		// Get store details
		$store_details = get_store_details();
		
		// Get base currency info for exchange rate display
		$base_currency = get_base_currency();
		$expense->base_currency_symbol = $base_currency->symbol;
		if (isset($base_currency->currency_code)) {
			$expense->base_currency_code = $base_currency->currency_code;
		}
		
		$data = array(
			'expense' => $expense,
			'store_details' => $store_details
		);
		
		$this->load->view('accounts/expense_receipt', $data);
	}
	
	// AJAX method to get exchange rate and convert currency
	public function get_exchange_rate(){
		$from_currency = $this->input->post('from_currency');
		$to_currency = $this->input->post('to_currency');
		$amount = $this->input->post('amount');
		
		$exchange_rate = get_exchange_rate($from_currency, $to_currency);
		$base_amount = convert_currency($amount, $from_currency, $to_currency);
		
		$from_currency_info = $this->db->select('currency_code, symbol')->where('id', $from_currency)->get('db_currency')->row();
		$base_currency_info = $this->db->select('currency_code, symbol')->where('id', $to_currency)->get('db_currency')->row();
		
		$response = array(
			'success' => true,
			'exchange_rate' => number_format($exchange_rate, 6),
			'base_amount' => $base_amount,
			'from_currency_code' => $from_currency_info->currency_code,
			'base_currency_code' => $base_currency_info->currency_code,
			'base_currency_symbol' => $base_currency_info->symbol
		);
		
		echo json_encode($response);
	}
	
	// AJAX method to check account balance
	public function check_account_balance(){
		$account_id = $this->input->post('account_id');
		$amount = $this->input->post('amount');
		$currency_id = $this->input->post('currency_id');
		
		// Recalculate account balance to ensure it's up to date
		update_account_balance($account_id);
		
		$account_balance = get_account_balance($account_id);
		$account_info = $this->db->select('a.account_name, a.currency_id, c.symbol, c.currency_code')
								->from('ac_accounts a')
								->join('db_currency c', 'a.currency_id = c.id', 'left')
								->where('a.id', $account_id)
								->get()->row();
		
		// Convert expense amount to account currency for comparison
		$expense_amount_in_account_currency = $amount;
		if ($currency_id && $currency_id != $account_info->currency_id) {
			$expense_amount_in_account_currency = convert_currency($amount, $currency_id, $account_info->currency_id);
		}
		
		$response = array(
			'success' => true,
			'balance' => $account_balance,
			'account_currency_id' => $account_info->currency_id,
			'account_currency_symbol' => $account_info->symbol,
			'account_currency_code' => $account_info->currency_code,
			'expense_amount_in_account_currency' => $expense_amount_in_account_currency,
			'is_sufficient' => $account_balance >= $expense_amount_in_account_currency
		);
		
		echo json_encode($response);
	}
	
	/* ######################################## EXPENSE CATEGORY END############################# */

}
