<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_create_audit_log_table extends CI_Migration {

    public function up()
    {
        $this->dbforge->add_field(array(
            'id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'user_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'action' => array(
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ),
            'table_name' => array(
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ),
            'record_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ),
            'old_values' => array(
                'type' => 'TEXT',
                'null' => TRUE
            ),
            'new_values' => array(
                'type' => 'TEXT',
                'null' => TRUE
            ),
            'ip_address' => array(
                'type' => 'VARCHAR',
                'constraint' => 45,
                'null' => TRUE
            ),
            'user_agent' => array(
                'type' => 'TEXT',
                'null' => TRUE
            ),
            'created_at' => array(
                'type' => 'TIMESTAMP',
                'null' => TRUE,
                'default' => 'CURRENT_TIMESTAMP'
            )
        ));
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('user_id');
        $this->dbforge->add_key('action');
        $this->dbforge->add_key('table_name');
        $this->dbforge->add_key('created_at');
        $this->dbforge->create_table('db_audit_log');
    }

    public function down()
    {
        $this->dbforge->drop_table('db_audit_log');
    }
}

