<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Money_deposit_model extends CI_Model {

	//Datatable start
	var $table = 'ac_moneydeposits as a';
	var $column_order = array( 
							'a.id',
							'a.deposit_date',
							'a.reference_no',
							'a.debit_account_id',
							'a.credit_account_id',
							'a.amount',
							'a.created_by',
							); //set column field database for datatable orderable
	var $column_search = array( 
							'a.id',
							'a.deposit_date',
							'a.reference_no',
							'a.debit_account_id',
							'a.credit_account_id',
							'a.amount',
							'a.created_by',
							);//set column field database for datatable searchable 

	var $order = array('a.id' => 'desc'); // default order 

	public function __construct()
	{
		parent::__construct();
	}

	private function _get_datatables_query()
	{
		
		$this->db->from($this->table);
		//if(!is_admin()){
			$this->db->where("a.store_id",get_current_store_id());
		//}

		$deposit_date = $this->input->post('deposit_date');
     	$deposit_date = system_fromatted_date($deposit_date);
     	if($deposit_date!='1970-01-01'){
     		$this->db->where("a.deposit_date=",$deposit_date);
     	}

     	$users = $this->input->post('users');
     	if($users && !empty($users)){
 	    	$this->db->where("upper(a.created_by)",strtoupper($users));
    	}
    	$debit_account_id = $this->input->post('debit_account_id');
     	if($debit_account_id && !empty($debit_account_id)){
 	    	$this->db->where("a.debit_account_id",$debit_account_id);
    	}
    	$credit_account_id = $this->input->post('credit_account_id');
     	if($credit_account_id && !empty($credit_account_id)){
 	    	$this->db->where("a.credit_account_id",$credit_account_id);
    	}
    	
     	

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->where("store_id",get_current_store_id());
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}

	//Save Deposits
	public function verify_and_save(){
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));
		$store_id=(store_module() && is_admin()) ? $store_id : get_current_store_id();	

		$this->db->query("ALTER TABLE ac_moneydeposits AUTO_INCREMENT = 1");

		// Get currency information
		$deposit_currency_id = isset($deposit_currency_id) ? $deposit_currency_id : get_base_currency_id();
		$exchange_rate = get_exchange_rate($deposit_currency_id, get_base_currency_id());
		$base_currency_amount = $amount * $exchange_rate;

		$info = array(  
	    				'store_id' 					=> $store_id,
	    				'deposit_date' 				=> system_fromatted_date($deposit_date),
	    				'debit_account_id' 			=> (!empty($debit_account_id)) ? $debit_account_id : null,
	    				'credit_account_id' 			=> $credit_account_id,
	    				'amount' 					=> $amount,
	    				'deposit_currency_id' 		=> $deposit_currency_id,
	    				'exchange_rate' 			=> $exchange_rate,
	    				'base_currency_amount' 		=> $base_currency_amount,
	    				'note' 						=> $note,
	    				'reference_no' 				=> $reference_no,
	    				/*System Info*/
	    				'created_date' 				=> $CUR_DATE,
	    				'created_time' 				=> $CUR_TIME,
	    				'created_by' 				=> $CUR_USERNAME,
	    				'system_ip' 				=> $SYSTEM_IP,
	    				'system_name' 				=> $SYSTEM_NAME,
	    				'status' 					=> 1,
	    			);
		$q1 = $this->db->insert('ac_moneydeposits', $info);
		if(!$q1){
			return "failed";
		}

		//Set the payment to specified account
		//ACCOUNT INSERT
		$insert_bit = insert_account_transaction(array(
													'transaction_type'  	=> 'DEPOSIT',
													'reference_table_id'  	=> $this->db->insert_id(),
													'debit_account_id'  	=> $debit_account_id,
													'credit_account_id'  	=> $credit_account_id,
													'debit_amt'  			=> (!empty($debit_account_id)) ? $amount : 0,
													'credit_amt'  			=> $amount,
													'transaction_currency_id' => $deposit_currency_id,
													'exchange_rate' 		=> $exchange_rate,
													'base_currency_debit_amt' => (!empty($debit_account_id)) ? $base_currency_amount : 0,
													'base_currency_credit_amt' => $base_currency_amount,
													'process'  				=> 'SAVE',
													'note'  				=> $note,
													'transaction_date'  	=> $CUR_DATE,
													'payment_code'  		=> '',
													'customer_id'  			=> '',
													'supplier_id'  			=> '',
											));
		if(!$insert_bit){
			return "failed";
		}
		//end


		$this->session->set_flashdata('success', 'Success!! Deposit Added Successfully!');
		return "success";
		
	}

	//Get deposit_details
	public function get_details($id,$data){
		//Validate This deposit already exist or not
		$query=$this->db->query("select * from ac_moneydeposits where upper(id)=upper('$id')");
		if($query->num_rows()==0){
			show_404();exit;
		}
		else{
			$query=$query->row();
			$data['q_id']=$query->id;
			$data['deposit_date']=$query->deposit_date;			
			$data['reference_no']=$query->reference_no;			
			$data['debit_account_id']=$query->debit_account_id;
			$data['credit_account_id']=$query->credit_account_id;
			$data['amount']=$query->amount;
			// Use deposit_currency_id column per schema
			$data['deposit_currency_id']=isset($query->deposit_currency_id) ? $query->deposit_currency_id : get_base_currency_id();
			$data['exchange_rate']=isset($query->exchange_rate) ? $query->exchange_rate : 1;
			$data['base_currency_amount']=isset($query->base_currency_amount) ? $query->base_currency_amount : $query->amount;
			$data['note']=$query->note;
			$data['store_id']=$query->store_id;
			return $data;
		}
	}
	public function update_money_deposit(){
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));
		
		// Get currency information
		$deposit_currency_id = isset($deposit_currency_id) ? $deposit_currency_id : get_base_currency_id();
		$exchange_rate = get_exchange_rate($deposit_currency_id, get_base_currency_id());
		$base_currency_amount = $amount * $exchange_rate;
		
		$info = array(
	    				'deposit_date' 			=> system_fromatted_date($deposit_date),
	    				'debit_account_id' 			=> (!empty($debit_account_id)) ? $debit_account_id : null,
	    				'credit_account_id' 			=> $credit_account_id,
	    				'amount' 					=> $amount,
	    				'deposit_currency_id' 		=> $deposit_currency_id,
	    				'exchange_rate' 			=> $exchange_rate,
	    				'base_currency_amount' 		=> $base_currency_amount,
	    				'note' 						=> $note,
	    				'reference_no' 				=> $reference_no,
	    			);
		

		$q1 = $this->db->where('id',$q_id)->update('ac_moneydeposits', $info);
		if(!$q1){
			return "failed";
		}

		//Set the payment to specified account
		
		//ACCOUNT INSERT
		$insert_bit = insert_account_transaction(array(
													'transaction_type'  	=> 'DEPOSIT',
													'reference_table_id'  	=> $q_id,
													'debit_account_id'  	=> $debit_account_id,
													'credit_account_id'  	=> $credit_account_id,
													'debit_amt'  			=> (!empty($debit_account_id)) ? $amount : 0,
													'credit_amt'  			=> $amount,
													'transaction_currency_id' => $deposit_currency_id,
													'exchange_rate' 		=> $exchange_rate,
													'base_currency_debit_amt' => (!empty($debit_account_id)) ? $base_currency_amount : 0,
													'base_currency_credit_amt' => $base_currency_amount,
													'process'  				=> 'UPDATE',
													'note'  				=> $note,
													'transaction_date'  	=> system_fromatted_date($deposit_date),
													'payment_code'  		=> '',
													'customer_id'  			=> '',
													'supplier_id'  			=> '',
											));
		if(!$insert_bit){
			return "failed";
		}
		
		//end


		$this->session->set_flashdata('success', 'Success!! Deposit Updated Successfully!');
		return "success";
		
	}
	
	
	public function delete_money_deposit_from_table($ids){
		$this->db->trans_begin();
		
		// Log the deletion attempt
		log_message('debug', 'Starting deposit deletion for IDs: ' . $ids);
		
		// Get affected accounts before deleting transactions
		$reset_accounts = $this->db->select("debit_account_id,credit_account_id")
			->where("ref_moneydeposits_id in ($ids)")
			->group_by("debit_account_id,credit_account_id")
			->get("ac_transactions");

		log_message('debug', 'Found ' . $reset_accounts->num_rows() . ' affected accounts');

		// Delete related transactions first (to avoid foreign key constraint issues)
		$this->db->where("ref_moneydeposits_id in ($ids)");
		$delete_transactions = $this->db->delete("ac_transactions");
		log_message('debug', 'Deleted transactions: ' . ($delete_transactions ? 'success' : 'failed'));
		if (!$delete_transactions){
			log_message('error', 'Failed to delete transactions: ' . $this->db->last_query());
			$this->db->trans_rollback();
			return "failed";
		}

		// Now delete the deposit records
		$this->db->where("id in ($ids)");
		//if not admin
		if(!is_admin()){
			$this->db->where("store_id",get_current_store_id());
		}

		$query1=$this->db->delete("ac_moneydeposits");
		log_message('debug', 'Deleted deposits: ' . ($query1 ? 'success' : 'failed'));
        if (!$query1){
			log_message('error', 'Failed to delete deposits: ' . $this->db->last_query());
			log_message('error', 'Database error: ' . json_encode($this->db->error()));
			$this->db->trans_rollback();
            return "failed";
        }

        // Update account balances
        if($reset_accounts->num_rows()>0){
        	foreach ($reset_accounts->result() as $res1) {
        		// Only update debit account balance if debit_account_id is not null
        		if($res1->debit_account_id) {
        			log_message('debug', 'Updating balance for debit account: ' . $res1->debit_account_id);
        			if(!update_account_balance($res1->debit_account_id)){
						log_message('error', 'Failed to update debit account balance: ' . $res1->debit_account_id);
						$this->db->trans_rollback();
						return 'failed';
					}
				}

				// Only update credit account balance if credit_account_id is not null
				if($res1->credit_account_id) {
					log_message('debug', 'Updating balance for credit account: ' . $res1->credit_account_id);
					if(!update_account_balance($res1->credit_account_id)){
						log_message('error', 'Failed to update credit account balance: ' . $res1->credit_account_id);
						$this->db->trans_rollback();
						return 'failed';
					}
				}
        	}
        }
        
        $this->db->trans_commit();
        log_message('debug', 'Deposit deletion completed successfully');
		return "success";
	}
}
