<!DOCTYPE html>
<html>

<head>
<!-- TABLES CSS CODE -->
<?php $this->load->view('comman/code_css.php');?>
</head>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <!-- Left side column. contains the logo and sidebar -->
  
  <?php $this->load->view('sidebar');?>
  <?php $CI =& get_instance(); ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <?= $this->lang->line('accounts_list'); ?>
        <small>View/Search Accounts</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"><?= $this->lang->line('accounts_list'); ?></li>
      </ol>
    </section>

    <!-- Main content -->
    <?= form_open('#', array('class' => '', 'id' => 'table_form')); ?>
    <input type="hidden" id='base_url' value="<?=$base_url;?>">
    <section class="content">
      <div class="row">
        <!-- ********** ALERT MESSAGE START******* -->
          <?php $this->load->view('comman/code_flashdata');?>
            <!-- ********** ALERT MESSAGE END******* -->
        <div class="col-xs-12">
          <div class="box box-primary">
            <div class="box-header ">
              <h3 class="box-title">&nbsp;</h3>
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label for="currency_filter" class="control-label">Filter by Currency:</label>
                    <select class="form-control select2" id="currency_filter" style="width: 200px;">
                      <option value="">All Currencies</option>
                      <?php
                        $currencies = get_currency_list();
                        foreach ($currencies as $currency) {
                          $base_indicator = ($currency->id == get_base_currency()->id) ? ' - Base Currency' : '';
                          echo '<option value="'.$currency->id.'">'.$currency->currency_name.' ('.$currency->currency_code.')'.$base_indicator.'</option>';
                        }
                      ?>
                    </select>
                  </div>
                </div>
                <div class="col-md-6 text-right">
                  <?php if($CI->permissions('accounts_add')) { ?>
                  <div class="box-tools">
                    <a class="btn btn-info" href="<?php echo $base_url; ?>accounts/add">
                    <i class="fa fa-plus"></i> <?= $this->lang->line('create_account'); ?></a>
                    <a class="btn btn-success" href="<?php echo $base_url; ?>accounts/multi_currency_report">
                    <i class="fa fa-exchange"></i> Multi-Currency Report</a>
                    <button type="button" class="btn btn-warning" onclick="showSetDefaultModal()">
                    <i class="fa fa-star"></i> Set Default Account</button>
                  </div>
                  <?php } ?>
                </div>
              </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example2" class="table table-bordered custom_hover" width="100%">
                <thead class="bg-gray ">
                <tr>
                  <th class="text-center">
                    <input type="checkbox" class="group_check checkbox" >
                  </th>
                  <!-- <th><?= $this->lang->line('store_name'); ?></th> -->
                  <th><?= $this->lang->line('account_code'); ?></th>
                  <th><?= $this->lang->line('account_name'); ?></th>
                  <th><?= $this->lang->line('parent_account_name'); ?></th>
                  <th>Currency</th>
                  <th><?= $this->lang->line('balance'); ?></th>
                  <th><?= $this->lang->line('created_by'); ?></th>
                  <th>Default</th>
                  <th><?= $this->lang->line('action'); ?></th>
                </tr>
                </thead>
                <tbody>
				
                </tbody>
               
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
    <?= form_close();?>
  </div>
  <!-- /.content-wrapper -->
  <?php $this->load->view('footer.php');?>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- SOUND CODE -->
      <?php $this->load->view('comman/code_js_sound.php');?>
      <!-- TABLES CODE -->
      <?php $this->load->view('comman/code_js.php');?>

<script type="text/javascript">
$(document).ready(function() {
    // Currency filter functionality
    $('#currency_filter').on('change', function() {
        var currencyId = $(this).val();
        table.column(4).search(currencyId).draw(); // Column 4 is the Currency column
    });
    
    //datatables
   var table = $('#example2').DataTable({ 
      "aLengthMenu": [[10, 25, 50, 100, 500], [10, 25, 50, 100, 500]],
      /* FOR EXPORT BUTTONS START*/
  dom:'<"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr><"pull-right margin-left-10 "B>>>tip',
      buttons: {
        buttons: [
            {
                className: 'btn bg-red color-palette btn-flat hidden delete_btn pull-left',
                text: 'Delete',
                action: function ( e, dt, node, config ) {
                    multi_delete();
                }
            },
            { extend: 'copy', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: [1,2,3,4,5,6,7]} },
            { extend: 'excel', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: [1,2,3,4,5,6,7]} },
            { extend: 'pdf', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: [1,2,3,4,5,6,7]} },
            { extend: 'print', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: [1,2,3,4,5,6,7]} },
            { extend: 'csv', className: 'btn bg-teal color-palette btn-flat',exportOptions: { columns: [1,2,3,4,5,6,7]} },
            { extend: 'colvis', className: 'btn bg-teal color-palette btn-flat',text:'Columns' },  

            ]
        },
        /* FOR EXPORT BUTTONS END */

        "processing": true, //Feature control the processing indicator.
        "serverSide": true, //Feature control DataTables' server-side processing mode.
        "order": [], //Initial no order.
        "responsive": true,
        language: {
            processing: '<div class="text-primary bg-primary" style="position: relative;z-index:100;overflow: visible;">Processing...</div>'
        },
        // Load data for the table's content from an Ajax source
        "ajax": {
            "url": "<?php echo site_url('accounts/ajax_list')?>",
            "type": "POST",
            "error": function(xhr, error, thrown) {
                console.log('DataTable AJAX Error:', error, thrown);
                console.log('Response:', xhr.responseText);
            },
            complete: function (data) {
             $('.column_checkbox').iCheck({
                checkboxClass: 'icheckbox_square-orange',
                /*uncheckedClass: 'bg-white',*/
                radioClass: 'iradio_square-orange',
                increaseArea: '10%' // optional
              });
             call_code();
              //$(".delete_btn").hide();
             },

        },

        //Set column definition initialisation properties.
        "columnDefs": [
        { 
            "targets": [ 0,7 ], //first column / numbering column
            "orderable": false, //set not orderable
        },
        {
            "targets" :[0],
            "className": "text-center",
        },
        
        ],
    });
    new $.fn.dataTable.FixedHeader( table );
});
</script>

<!-- Set Default Account Modal -->
<div class="modal fade" id="setDefaultModal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
        <h4 class="modal-title">
          <i class="fa fa-star text-warning"></i> Set Default Account for Payments
        </h4>
      </div>
      <div class="modal-body">
        <div class="form-group">
          <label for="default_account_select">Select Default Account:</label>
          <select class="form-control select2" id="default_account_select" style="width: 100%;">
            <option value="">-Select Account-</option>
            <?= get_accounts_select_list(get_store_details()->default_account_id); ?>
          </select>
          <small class="text-muted">This account will be automatically selected for payments when possible.</small>
        </div>
        <div class="alert alert-info">
          <i class="fa fa-info-circle"></i>
          <strong>Note:</strong> The default account should use the base currency for best compatibility with payment processing.
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-warning" onclick="setDefaultAccount()">
          <i class="fa fa-star"></i> Set as Default
        </button>
      </div>
    </div>
  </div>
</div>

<script src="<?php echo $theme_link; ?>js/accounts/accounts.js"></script>
<!-- Make sidebar menu hughlighter/selector -->
<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>

<script>
function showSetDefaultModal() {
  $('#setDefaultModal').modal('show');
}

function setDefaultAccount() {
  var accountId = $('#default_account_select').val();
  console.log('Selected account ID:', accountId);
  
  if (!accountId) {
    alert('Please select an account first.');
    return;
  }
  
  $.ajax({
    url: '<?= base_url(); ?>accounts/set_default_account',
    type: 'POST',
    data: { account_id: accountId },
    dataType: 'json',
    success: function(response) {
      console.log('Response:', response);
      if (response.success) {
        alert('Default account set successfully!');
        $('#setDefaultModal').modal('hide');
        // Reload the table to show updated default status
        $('#example2').DataTable().ajax.reload();
      } else {
        alert('Error: ' + response.message);
      }
    },
    error: function(xhr, status, error) {
      console.log('AJAX Error:', xhr.responseText);
      alert('Error setting default account. Please try again.');
    }
  });
}
</script>
		
</body>
</html>
