<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Basic Information</h5>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <tr>
                        <td><strong>ID:</strong></td>
                        <td><?php echo $audit_record->id; ?></td>
                    </tr>
                    <tr>
                        <td><strong>User:</strong></td>
                        <td><?php echo $audit_record->username; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Action:</strong></td>
                        <td><span class="badge badge-primary"><?php echo ucfirst($audit_record->action); ?></span></td>
                    </tr>
                    <tr>
                        <td><strong>Module:</strong></td>
                        <td><span class="badge badge-info"><?php echo ucfirst($audit_record->module); ?></span></td>
                    </tr>
                    <tr>
                        <td><strong>Table:</strong></td>
                        <td><?php echo $audit_record->table_name ?: 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Record ID:</strong></td>
                        <td><?php echo $audit_record->record_id ?: 'N/A'; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Description:</strong></td>
                        <td><?php echo $audit_record->description ?: 'N/A'; ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">System Information</h5>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <tr>
                        <td><strong>IP Address:</strong></td>
                        <td><?php echo $audit_record->ip_address; ?></td>
                    </tr>
                    <tr>
                        <td><strong>User Agent:</strong></td>
                        <td><?php echo $audit_record->user_agent; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Store ID:</strong></td>
                        <td><?php echo $audit_record->store_id; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Created Date:</strong></td>
                        <td><?php echo date('d-m-Y H:i:s', strtotime($audit_record->created_date)); ?></td>
                    </tr>
                    <tr>
                        <td><strong>System IP:</strong></td>
                        <td><?php echo $audit_record->system_ip; ?></td>
                    </tr>
                    <tr>
                        <td><strong>System Name:</strong></td>
                        <td><?php echo $audit_record->system_name; ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<?php if($audit_record->old_values || $audit_record->new_values): ?>
<div class="row mt-3">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Data Changes</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if($audit_record->old_values): ?>
                    <div class="col-md-6">
                        <h6 class="text-danger">Old Values</h6>
                        <pre class="bg-light p-3" style="max-height: 300px; overflow-y: auto;"><?php echo json_encode(json_decode($audit_record->old_values), JSON_PRETTY_PRINT); ?></pre>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($audit_record->new_values): ?>
                    <div class="col-md-6">
                        <h6 class="text-success">New Values</h6>
                        <pre class="bg-light p-3" style="max-height: 300px; overflow-y: auto;"><?php echo json_encode(json_decode($audit_record->new_values), JSON_PRETTY_PRINT); ?></pre>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
