<?php
/**
 * A4 Print Template for Reports
 * This template provides a consistent A4 print layout for all reports
 */

// Get company information
$company_name = $store_name ? $store_name : "NCS Billing Book";
$company_address = isset($store_address) ? $store_address : "";
$company_phone = isset($store_phone) ? $store_phone : "";
$company_email = isset($store_email) ? $store_email : "";
?>

<style>
/* Print Styles for A4 Reports */
@media print {
    body {
        font-family: Arial, sans-serif;
        font-size: 12px;
        margin: 0;
        padding: 20px;
        color: #333;
    }
    
    .print-header {
        text-align: center;
        margin-bottom: 30px;
        border-bottom: 2px solid #333;
        padding-bottom: 20px;
    }
    
    .print-header h1 {
        font-size: 24px;
        font-weight: bold;
        margin: 0 0 10px 0;
        color: #333;
    }
    
    .print-header .company-info {
        font-size: 14px;
        color: #666;
        margin: 5px 0;
    }
    
    .print-header .report-title {
        font-size: 18px;
        font-weight: bold;
        margin: 15px 0 10px 0;
        color: #2c3e50;
    }
    
    .print-header .report-filters {
        font-size: 12px;
        color: #666;
        margin: 5px 0;
    }
    
    .print-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    
    .print-table th {
        background-color: #34495e !important;
        color: white !important;
        font-weight: bold;
        padding: 8px 6px;
        text-align: center;
        border: 1px solid #333;
        font-size: 11px;
    }
    
    .print-table td {
        padding: 6px;
        border: 1px solid #333;
        font-size: 11px;
        vertical-align: top;
    }
    
    .print-table tr:nth-child(even) {
        background-color: #f8f9fa;
    }
    
    .print-table .text-right {
        text-align: right;
    }
    
    .print-table .text-center {
        text-align: center;
    }
    
    .print-table .text-left {
        text-align: left;
    }
    
    .print-footer {
        margin-top: 30px;
        text-align: center;
        font-size: 10px;
        color: #666;
        border-top: 1px solid #ccc;
        padding-top: 10px;
    }
    
    .page-break {
        page-break-before: always;
    }
    
    @page {
        margin: 1cm;
        size: A4;
    }
}

/* Screen styles for print preview */
.print-preview {
    font-family: Arial, sans-serif;
    font-size: 12px;
    margin: 20px;
    padding: 20px;
    border: 1px solid #ddd;
    background: white;
}

.print-preview .print-header {
    text-align: center;
    margin-bottom: 30px;
    border-bottom: 2px solid #333;
    padding-bottom: 20px;
}

.print-preview .print-header h1 {
    font-size: 24px;
    font-weight: bold;
    margin: 0 0 10px 0;
    color: #333;
}

.print-preview .print-header .company-info {
    font-size: 14px;
    color: #666;
    margin: 5px 0;
}

.print-preview .print-header .report-title {
    font-size: 18px;
    font-weight: bold;
    margin: 15px 0 10px 0;
    color: #2c3e50;
}

.print-preview .print-header .report-filters {
    font-size: 12px;
    color: #666;
    margin: 5px 0;
}

.print-preview .print-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

.print-preview .print-table th {
    background-color: #34495e;
    color: white;
    font-weight: bold;
    padding: 8px 6px;
    text-align: center;
    border: 1px solid #333;
    font-size: 11px;
}

.print-preview .print-table td {
    padding: 6px;
    border: 1px solid #333;
    font-size: 11px;
    vertical-align: top;
}

.print-preview .print-table tr:nth-child(even) {
    background-color: #f8f9fa;
}

.print-preview .print-table .text-right {
    text-align: right;
}

.print-preview .print-table .text-center {
    text-align: center;
}

.print-preview .print-table .text-left {
    text-align: left;
}

.print-preview .print-footer {
    margin-top: 30px;
    text-align: center;
    font-size: 10px;
    color: #666;
    border-top: 1px solid #ccc;
    padding-top: 10px;
}
</style>

<script>
/**
 * Universal A4 Print Function for Reports
 * Usage: printReport(reportTitle, tableHeaders, tableData, filters)
 */
function printReport(reportTitle, tableHeaders, tableData, filters = {}) {
    // Check if report data exists
    if (!tableData || tableData.trim() === '') {
        alert('Please generate the report first before printing.');
        return;
    }
    
    // Create print window
    var printWindow = window.open('', '_blank', 'width=800,height=600');
    
    // Get company information
    var companyName = '<?php echo $company_name; ?>';
    var companyAddress = '<?php echo $company_address; ?>';
    var companyPhone = '<?php echo $company_phone; ?>';
    var companyEmail = '<?php echo $company_email; ?>';
    
    // Get current date
    var currentDate = new Date().toLocaleDateString();
    
    // Build filters display
    var filtersDisplay = '';
    for (var key in filters) {
        if (filters[key] && filters[key] !== '') {
            filtersDisplay += '<div class="report-filters"><strong>' + key + ':</strong> ' + filters[key] + '</div>';
        }
    }
    
    // Build print content
    var printContent = `
        <!DOCTYPE html>
        <html>
        <head>
            <title>${reportTitle} - ${companyName}</title>
            <style>
                body { font-family: Arial, sans-serif; font-size: 12px; margin: 0; padding: 20px; }
                .print-header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 20px; }
                .print-header h1 { font-size: 24px; font-weight: bold; margin: 0 0 10px 0; color: #333; }
                .print-header .company-info { font-size: 14px; color: #666; margin: 5px 0; }
                .print-header .report-title { font-size: 18px; font-weight: bold; margin: 15px 0 10px 0; color: #2c3e50; }
                .print-header .report-filters { font-size: 12px; color: #666; margin: 5px 0; }
                .print-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                .print-table th { background-color: #34495e; color: white; font-weight: bold; padding: 8px 6px; text-align: center; border: 1px solid #333; font-size: 11px; }
                .print-table td { padding: 6px; border: 1px solid #333; font-size: 11px; vertical-align: top; }
                .print-table tr:nth-child(even) { background-color: #f8f9fa; }
                .print-table .text-right { text-align: right; }
                .print-table .text-center { text-align: center; }
                .print-table .text-left { text-align: left; }
                .print-footer { margin-top: 30px; text-align: center; font-size: 10px; color: #666; border-top: 1px solid #ccc; padding-top: 10px; }
                @page { margin: 1cm; size: A4; }
            </style>
        </head>
        <body>
            <div class="print-header">
                <h1>${companyName}</h1>
                <div class="company-info">${companyAddress}</div>
                <div class="company-info">${companyPhone}</div>
                <div class="company-info">${companyEmail}</div>
                <div class="report-title">${reportTitle}</div>
                ${filtersDisplay}
                <div class="report-filters"><strong>Generated:</strong> ${currentDate}</div>
            </div>
            
            <table class="print-table">
                <thead>
                    ${tableHeaders}
                </thead>
                <tbody>
                    ${tableData}
                </tbody>
            </table>
            
            <div class="print-footer">
                <p>This report was generated on ${currentDate} by ${companyName} System</p>
                <p>For any queries, please contact us at ${companyEmail}</p>
            </div>
        </body>
        </html>
    `;
    
    // Write content and print
    printWindow.document.write(printContent);
    printWindow.document.close();
    
    // Wait for content to load, then print
    printWindow.onload = function() {
        printWindow.focus();
        printWindow.print();
        printWindow.close();
    };
}

/**
 * Helper function to get form filters for reports
 */
function getReportFilters() {
    var filters = {};
    
    // Common filter fields
    var filterFields = ['store_id', 'warehouse_id', 'customer_id', 'supplier_id', 'brand_id', 'category_id', 'from_date', 'to_date', 'created_by'];
    
    filterFields.forEach(function(field) {
        var element = document.getElementById(field);
        if (element) {
            if (element.tagName === 'SELECT') {
                filters[field.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase())] = element.options[element.selectedIndex].text;
            } else {
                filters[field.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase())] = element.value;
            }
        }
    });
    
    return filters;
}
</script>
