<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php print $SITE_TITLE; ?> | OTP Verification</title>
  <link rel='shortcut icon' href='<?php echo $theme_link; ?>images/favicon.ico' />
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>bootstrap/css/bootstrap.min.css">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>dist/css/AdminLTE.min.css">
  <!-- iCheck -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>plugins/iCheck/square/blue.css">
  <?php 
      $lang = trim(strtoupper($this->session->userdata('language')));
      if($lang==strtoupper('arabic') || $lang==strtoupper('urdu')) {?>
  <!-- RTL For arabic styles -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>bootstrap/css/bootstrap.rtl.min.css">
  <link rel="stylesheet" href="<?php echo $theme_link; ?>dist/css/AdminLTE.rtl.min.css">
  <?php } ?>
  
  <!-- Modern Authentication Styles -->
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }

    .auth-container {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border-radius: 15px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
      padding: 30px;
      width: 100%;
      max-width: 400px;
      position: relative;
      overflow: hidden;
    }

    .auth-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 3px;
      background: linear-gradient(90deg, #667eea, #764ba2, #f093fb);
    }

    .auth-header {
      text-align: center;
      margin-bottom: 25px;
    }

    .auth-logo {
      margin: 0 auto 15px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .auth-logo img {
      max-width: 120px;
      max-height: 60px;
      width: auto;
      height: auto;
    }

    .auth-title {
      font-size: 24px;
      font-weight: 700;
      color: #2d3748;
      margin-bottom: 5px;
    }

    .auth-subtitle {
      color: #718096;
      font-size: 14px;
      line-height: 1.4;
    }

    .form-group {
      margin-bottom: 20px;
      position: relative;
    }

    .form-control {
      width: 100%;
      padding: 12px 15px 12px 45px;
      border: 2px solid #e2e8f0;
      border-radius: 8px;
      font-size: 14px;
      transition: all 0.3s ease;
      background: #f8fafc;
      text-align: center;
      letter-spacing: 2px;
      font-weight: 600;
    }

    .form-control:focus {
      outline: none;
      border-color: #667eea;
      background: #fff;
      box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.1);
    }

    .form-control::placeholder {
      color: #a0aec0;
      letter-spacing: normal;
      font-weight: normal;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #a0aec0;
      font-size: 16px;
      transition: color 0.3s ease;
    }

    .form-control:focus + .input-icon {
      color: #667eea;
    }

    .btn-submit {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #667eea, #764ba2);
      border: none;
      border-radius: 8px;
      color: white;
      font-size: 14px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .btn-submit:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
    }

    .btn-submit:active {
      transform: translateY(0);
    }

    .btn-submit:disabled {
      opacity: 0.7;
      cursor: not-allowed;
      transform: none;
    }

    .auth-links {
      display: flex;
      justify-content: space-between;
      margin-top: 25px;
      flex-wrap: wrap;
      gap: 10px;
    }

    .auth-link {
      color: #667eea;
      text-decoration: none;
      font-weight: 500;
      transition: color 0.3s ease;
    }

    .auth-link:hover {
      color: #764ba2;
      text-decoration: none;
    }

    .alert {
      padding: 12px 16px;
      border-radius: 8px;
      margin-bottom: 20px;
      font-weight: 500;
    }

    .alert-danger {
      background: #fed7d7;
      color: #c53030;
      border: 1px solid #feb2b2;
    }

    .alert-success {
      background: #c6f6d5;
      color: #2f855a;
      border: 1px solid #9ae6b4;
    }

    .alert-warning {
      background: #fef5e7;
      color: #d69e2e;
      border: 1px solid #fbd38d;
    }

    .alert-info {
      background: #bee3f8;
      color: #2b6cb0;
      border: 1px solid #90cdf4;
    }

    .language-selector {
      margin-top: 20px;
      text-align: center;
    }

    .language_id {
      border: 2px solid #e2e8f0;
      border-radius: 8px;
      padding: 10px 15px;
      font-size: 14px;
      color: #4a5568;
      background: #f8fafc;
      transition: all 0.3s ease;
      min-width: 200px;
    }

    .language_id:focus {
      outline: none;
      border-color: #667eea;
      background: #fff;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .info-section {
      background: linear-gradient(135deg, #e6fffa 0%, #f0fff4 100%);
      border-radius: 12px;
      padding: 20px;
      margin-bottom: 25px;
      border-left: 4px solid #38b2ac;
    }

    .info-icon {
      color: #38b2ac;
      font-size: 20px;
      margin-right: 10px;
    }

    .info-text {
      color: #2d3748;
      font-size: 14px;
      line-height: 1.5;
    }

    .otp-input {
      font-size: 24px;
      text-align: center;
      letter-spacing: 8px;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .auth-container {
        padding: 30px 20px;
        margin: 10px;
      }

      .auth-title {
        font-size: 24px;
      }

      .form-control {
        padding: 12px 15px 12px 45px;
        font-size: 14px;
      }

      .input-icon {
        left: 15px;
        font-size: 16px;
      }

      .auth-links {
        flex-direction: column;
        text-align: center;
      }

      .language_id {
        min-width: 150px;
      }
    }

    @media (max-width: 480px) {
      .auth-container {
        padding: 30px 20px;
        margin: 10px;
        max-width: calc(100% - 20px);
      }

      .auth-title {
        font-size: 24px;
      }

      .auth-subtitle {
        font-size: 14px;
      }

      .form-group {
        margin-bottom: 20px;
      }

      .form-control {
        padding: 14px 16px 14px 45px;
        font-size: 16px;
        min-height: 50px;
      }

      .input-icon {
        left: 15px;
        font-size: 18px;
      }

      .btn-submit {
        padding: 14px;
        font-size: 16px;
        min-height: 50px;
      }

      .auth-logo img {
        max-width: 140px;
        max-height: 70px;
      }

      .alert {
        padding: 12px 16px;
        font-size: 14px;
      }
    }

    /* Loading Animation */
    .loading {
      display: inline-block;
      width: 20px;
      height: 20px;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-radius: 50%;
      border-top-color: #fff;
      animation: spin 1s ease-in-out infinite;
    }

    @keyframes spin {
      to { transform: rotate(360deg); }
    }
  </style>
</head>
<body>
  <!-- language -->
  <input type="hidden" id="base_url" value="<?=base_url()?>">
  <!-- language end -->

  <div class="auth-container">
    <div class="auth-header">
      <div class="auth-logo">
        <img src="<?php echo base_url(get_site_logo());?>" alt="Logo">
      </div>
      <h1 class="auth-title">Verify OTP</h1>
      <p class="auth-subtitle">Enter the 6-digit verification code sent to your email address.</p>
    </div>

    <!-- Info Section -->
    <div class="info-section">
      <i class="fa fa-shield info-icon"></i>
      <span class="info-text">Check your email for the verification code. If you don't see it, check your spam folder.</span>
  </div>

    <!-- Alert Messages -->
    <?php if($this->session->flashdata('failed')): ?>
      <div class="alert alert-danger">
        <i class="fa fa-exclamation-circle"></i> <?php echo $this->session->flashdata('failed'); ?>
      </div>
    <?php endif; ?>
    
    <?php if($this->session->flashdata('success')): ?>
      <div class="alert alert-success">
        <i class="fa fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
      </div>
    <?php endif; ?>

    <form action="<?php echo $base_url; ?>login/verify_otp" method="post" id="otp-form">
      <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
      <input type="hidden" name="email" id="email" value="<?= $this->session->userdata('email')?>">
      
      <div class="form-group">
        <input type="text" class="form-control otp-input" placeholder="000000" id="otp" name="otp" autofocus required maxlength="6" pattern="[0-9]{6}">
        <i class="fa fa-key input-icon"></i>
      </div>
       
      <button type="submit" class="btn-submit" id="submit-btn">
        <span class="btn-text"><?= $this->lang->line('submit'); ?></span>
        <span class="loading" style="display: none;"></span>
      </button>
    </form>

    <div class="auth-links">
      <?php if(store_module()): ?>
        <a href="<?=base_url('register')?>" class="auth-link">
          <i class="fa fa-user-plus"></i> <?= $this->lang->line('register'); ?>
        </a>
      <?php endif; ?>
      <a href="<?=base_url('login')?>" class="auth-link">
        <i class="fa fa-arrow-left"></i> <?= $this->lang->line('sign_in'); ?>
      </a>
    </div>

    <!-- Language Selector -->
    <div class="language-selector">
      <?php $this->load->view('comman/language.php');?>
    </div>
  </div>

<!-- jQuery 2.2.3 -->
<script src="<?php echo $theme_link; ?>plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="<?php echo $theme_link; ?>bootstrap/js/bootstrap.min.js"></script>
<!-- iCheck -->
<script src="<?php echo $theme_link; ?>plugins/iCheck/icheck.min.js"></script>
<script src="<?php echo $theme_link; ?>js/language.js"></script>
  
<script>
    $(document).ready(function() {
      // Initialize iCheck for any checkboxes/radios
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
        increaseArea: '20%'
      });

      // Setup AJAX CSRF token
      $.ajaxSetup({ 
        data: {'<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>' }  
      });

      // Form submission with loading state
      $('#otp-form').on('submit', function(e) {
        const $btn = $('#submit-btn');
        const $btnText = $btn.find('.btn-text');
        const $loading = $btn.find('.loading');
        
        // Show loading state
        $btn.prop('disabled', true);
        $btnText.hide();
        $loading.show();
      });

      // OTP input formatting and validation
      $('#otp').on('input', function() {
        // Remove any non-numeric characters
        this.value = this.value.replace(/[^0-9]/g, '');
        
        // Limit to 6 digits
        if (this.value.length > 6) {
          this.value = this.value.slice(0, 6);
        }
        
        // Auto-submit when 6 digits are entered
        if (this.value.length === 6) {
          setTimeout(() => {
            $('#otp-form').submit();
          }, 500);
        }
      });

      // Add focus effects to form inputs
      $('.form-control').on('focus', function() {
        $(this).parent().addClass('focused');
      }).on('blur', function() {
        if ($(this).val() === '') {
          $(this).parent().removeClass('focused');
        }
      });

      // Check if inputs have values on page load
      $('.form-control').each(function() {
        if ($(this).val() !== '') {
          $(this).parent().addClass('focused');
        }
      });

      // OTP validation
      $('#otp').on('blur', function() {
        const otp = $(this).val();
        
        if (otp && otp.length !== 6) {
          $(this).addClass('error');
          if (!$(this).next('.error-message').length) {
            $(this).after('<small class="error-message" style="color: #c53030; font-size: 12px; margin-top: 5px; display: block;">Please enter a 6-digit code</small>');
          }
        } else {
          $(this).removeClass('error');
          $(this).next('.error-message').remove();
        }
      });

      // Auto-focus on OTP input
      $('#otp').focus();
    });
</script>
</body>
</html>
