<?php
// Get store information for print functions
$store = get_store_details();
$store_name = get_store_name();

// Ensure we have a proper store name
if (empty($store_name) || $store_name === true || $store_name === 1) {
    $store_name = isset($store->store_name) ? $store->store_name : 'NCS Billing Book';
}

$store_address = isset($store->address) ? $store->address : "123 Main Street, New York, NY 10001";
$store_phone = isset($store->mobile) ? "Phone: " . $store->mobile : "Phone: 9999999999";
$store_email = isset($store->email) ? "Email: " . $store->email : "Email: billingbook@email.com";
?>
<!DOCTYPE html>
<html>
<head>
    <!-- TABLES CSS CODE -->
    <?php include"comman/code_css.php"; ?>
    <style>
        @media print {
            .no-print { display: none !important; }
            .print-break { page-break-before: always; }
            body { 
                font-size: 12px; 
                margin: 0; 
                padding: 0; 
                background: white !important;
            }
            .report-container { 
                margin: 0; 
                padding: 20px; 
                box-shadow: none;
                border: none;
            }
            .company-header {
                margin-bottom: 20px;
                padding-bottom: 15px;
                border-bottom: 2px solid #000;
            }
            .company-name {
                font-size: 20px;
                margin: 10px 0;
            }
            .company-details {
                font-size: 12px;
            }
            .report-title {
                font-size: 18px;
                margin: 15px 0;
            }
            .report-period {
                font-size: 14px;
                margin-bottom: 20px;
            }
            .cash-flow-table {
                font-size: 11px;
                border-collapse: collapse;
            }
            .cash-flow-table th,
            .cash-flow-table td {
                border: 1px solid #000;
                padding: 4px 8px;
                text-align: left;
            }
            .cash-flow-table th {
                background-color: #f0f0f0;
                font-weight: bold;
            }
            .section-header {
                background-color: #e0e0e0 !important;
                font-weight: bold;
            }
            .total-row {
                background-color: #f0f0f0 !important;
                font-weight: bold;
            }
            .grand-total-row {
                background-color: #d0d0d0 !important;
                font-weight: bold;
                font-size: 14px;
            }
        }
        
        .report-container {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-top: 20px;
            padding: 30px;
            min-height: 400px;
        }
        
        .company-header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e0e0e0;
        }
        
        .company-logo {
            max-height: 60px;
            margin-bottom: 15px;
        }
        
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #2c3e50;
            margin: 10px 0;
        }
        
        .company-details {
            font-size: 14px;
            color: #666;
            line-height: 1.6;
        }
        
        .report-title {
            font-size: 24px;
            font-weight: bold;
            color: #e74c3c;
            text-align: center;
            margin: 20px 0;
            text-transform: uppercase;
            letter-spacing: 1px;
            background: #fdf2f2;
            padding: 15px;
            border: 2px solid #e74c3c;
            border-radius: 8px;
        }
        
        .report-period {
            font-size: 16px;
            color: #666;
            text-align: center;
            margin-bottom: 30px;
            font-weight: bold;
        }
        
        .export-buttons {
            text-align: center;
            margin: 20px 0;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
        }
        
        .export-btn {
            display: inline-block;
            padding: 12px 24px;
            margin: 5px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            font-weight: bold;
            text-decoration: none;
            transition: all 0.3s ease;
            min-width: 120px;
        }
        
        .export-btn.primary { background: #3498db; color: white; }
        .export-btn.success { background: #27ae60; color: white; }
        .export-btn.warning { background: #f39c12; color: white; }
        .export-btn.info { background: #17a2b8; color: white; }
        .export-btn.danger { background: #e74c3c; color: white; }
        
        .export-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        }
        
        .cash-flow-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background: white;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .cash-flow-table th {
            background: #3498db;
            color: white;
            padding: 15px;
            text-align: left;
            font-weight: bold;
            font-size: 14px;
        }
        
        .cash-flow-table td {
            padding: 12px 15px;
            border-bottom: 1px solid #e0e0e0;
            font-size: 14px;
        }
        
        .cash-flow-table tr:hover {
            background-color: #f8f9fa;
        }
        
        .section-header {
            background-color: #f8f9fa !important;
            font-weight: bold;
            color: #2c3e50;
            font-size: 16px;
        }
        
        .total-row {
            background-color: #fff3cd !important;
            font-weight: bold;
            color: #856404;
        }
        
        .grand-total-row {
            background-color: #d4edda !important;
            font-weight: bold;
            color: #155724;
            font-size: 16px;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .text-bold {
            font-weight: bold;
        }
        
        .welcome-message {
            text-align: center;
            padding: 60px 20px;
            color: #666;
        }
        
        .welcome-message i {
            font-size: 48px;
            margin-bottom: 20px;
            color: #3498db;
        }
        
        .welcome-message h3 {
            color: #2c3e50;
            margin-bottom: 15px;
        }
        
        .welcome-message p {
            margin-bottom: 10px;
            font-size: 16px;
        }
        
        .welcome-message small {
            color: #999;
            font-size: 14px;
        }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php include"sidebar.php"; ?>
        
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    <?=$page_title;?>
                    <small>Professional Report</small>
                </h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i>Home</a></li>
                    <li class="active"><?=$page_title;?></li>
                </ol>
            </section>
            
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        <!-- Filters -->
                        <div class="box box-primary no-print">
                            <div class="box-header with-border">
                                <h3 class="box-title">Report Filters</h3>
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>From Date</label>
                                            <div class="input-group date">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" class="form-control pull-right datepicker" id="from_date" name="from_date" value="<?php echo show_date(date('d-m-Y'));?>" >
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>To Date</label>
                                            <div class="input-group date">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" class="form-control pull-right datepicker" id="to_date" name="to_date" value="<?php echo show_date(date('d-m-Y'))?>" >
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>Store</label>
                                            <?php if(store_module() && is_admin()) { 
                                                $this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>get_current_store_id(),'div_length'=>'','label_length'=>'','show_all'=>'true')); 
                                            } else {
                                                echo "<select class='form-control' id='store_id' name='store_id'>";
                                                echo "<option value='".get_current_store_id()."'>".get_store_name(get_current_store_id())."</option>";
                                                echo "</select>";
                                            } ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <div>
                                                <button type="button" class="btn btn-primary btn-block" id="generate-report">
                                                    <i class="fa fa-refresh"></i> Generate Report
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Report Container -->
                        <div class="report-container" id="report-container" style="display: none;">
                            <!-- Welcome Message -->
                            <div id="welcome-message" class="text-center" style="padding: 40px; color: #666;">
                                <i class="fa fa-money fa-3x" style="margin-bottom: 20px; color: #3498db;"></i>
                                <h3>Cash Flow Statement</h3>
                                <p>Select date range and click 'Generate Report' to view cash flow analysis</p>
                                <p><small>You can also adjust the date range to filter transactions</small></p>
                            </div>
                            
                            <!-- Company Header -->
                            <div class="company-header">
                                <?php 
                                $store_info = get_store_details();
                                $logo_path = base_url('uploads/store_logo/'.$store_info->store_logo);
                                ?>
                                <?php if(!empty($store_info->store_logo) && file_exists(FCPATH.'uploads/store_logo/'.$store_info->store_logo)): ?>
                                    <img src="<?php echo $logo_path; ?>" alt="Company Logo" class="company-logo">
                                <?php endif; ?>
                                
                                <div class="company-name"><?php echo $store_info->store_name; ?></div>
                                <div class="company-details">
                                    <?php if(!empty($store_info->address)): ?>
                                        <?php echo $store_info->address; ?><br>
                                    <?php endif; ?>
                                    <?php if(!empty($store_info->mobile)): ?>
                                        Phone: <?php echo $store_info->mobile; ?><br>
                                    <?php endif; ?>
                                    <?php if(!empty($store_info->email)): ?>
                                        Email: <?php echo $store_info->email; ?><br>
                                    <?php endif; ?>
                                    <?php if(!empty($store_info->store_website)): ?>
                                        Website: <?php echo $store_info->store_website; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Report Content -->
                            <div id="cash-flow-content">
                                <!-- Cash flow data will be loaded here -->
                            </div>
                            
                            <!-- Export Buttons -->
                            <div class="export-buttons no-print">
                                <button class="export-btn success" onclick="exportToExcel()">
                                    <i class="fa fa-file-excel-o"></i> Export Excel
                                </button>
                                <button class="export-btn info" onclick="printCashFlowReport()">
                                    <i class="fa fa-print"></i> Print A4
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
    
    <!-- jQuery 3 -->
    <script src="<?php echo base_url('assets/bower_components/jquery/dist/jquery.min.js'); ?>"></script>
    <!-- Bootstrap 3.3.7 -->
    <script src="<?php echo base_url('assets/bower_components/bootstrap/dist/js/bootstrap.min.js'); ?>"></script>
    <!-- Select2 -->
    <script src="<?php echo base_url('assets/bower_components/select2/dist/js/select2.full.min.js'); ?>"></script>
    <!-- InputMask -->
    <script src="<?php echo base_url('assets/plugins/input-mask/jquery.inputmask.js'); ?>"></script>
    <script src="<?php echo base_url('assets/plugins/input-mask/jquery.inputmask.date.extensions.js'); ?>"></script>
    <script src="<?php echo base_url('assets/plugins/input-mask/jquery.inputmask.extensions.js'); ?>"></script>
    <!-- date-range-picker -->
    <script src="<?php echo base_url('assets/bower_components/moment/min/moment.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/bower_components/bootstrap-daterangepicker/daterangepicker.js'); ?>"></script>
    <!-- bootstrap datepicker -->
    <script src="<?php echo base_url('assets/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js'); ?>"></script>
    <!-- bootstrap color picker -->
    <script src="<?php echo base_url('assets/bower_components/bootstrap-colorpicker/dist/js/bootstrap-colorpicker.min.js'); ?>"></script>
    <!-- bootstrap time picker -->
    <script src="<?php echo base_url('assets/plugins/timepicker/bootstrap-timepicker.min.js'); ?>"></script>
    <!-- SlimScroll -->
    <script src="<?php echo base_url('assets/bower_components/jquery-slimscroll/jquery.slimscroll.min.js'); ?>"></script>
    <!-- iCheck 1.0.1 -->
    <script src="<?php echo base_url('assets/plugins/iCheck/icheck.min.js'); ?>"></script>
    <!-- FastClick -->
    <script src="<?php echo base_url('assets/bower_components/fastclick/lib/fastclick.js'); ?>"></script>
    <!-- AdminLTE App -->
    <script src="<?php echo base_url('assets/dist/js/adminlte.min.js'); ?>"></script>
    <!-- AdminLTE for demo purposes -->
    <script src="<?php echo base_url('assets/dist/js/demo.js'); ?>"></script>
    
    <!-- Export functionality -->
    <script src="<?php echo base_url('assets/tableExport/tableExport.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/tableExport/jquery.base64.js'); ?>"></script>
    <script src="<?php echo base_url('assets/tableExport/html2canvas.js'); ?>"></script>
    <script src="<?php echo base_url('assets/tableExport/jspdf/libs/sprintf.js'); ?>"></script>
    <script src="<?php echo base_url('assets/tableExport/jspdf/jspdf.js'); ?>"></script>
    <script src="<?php echo base_url('assets/tableExport/jspdf/libs/base64.js'); ?>"></script>
    
    <script>
    var base_url = '<?php echo base_url(); ?>';
    var currentReportData = null;
    
    $(document).ready(function() {
        // Initialize date pickers
        $('.datepicker').datepicker({
            autoclose: true,
            format: 'dd-mm-yyyy'
        });
        
        // Generate report button click
        $('#generate-report').click(function() {
            loadCashFlowReport();
        });
        
        // Store change event
        $('#store_id').change(function() {
            // Reload report if store changes
            if($('#cash-flow-content').find('table').length > 0) {
                loadCashFlowReport();
            }
        });
    });
    
    function loadCashFlowReport() {
        var from_date = $('#from_date').val();
        var to_date = $('#to_date').val();
        var store_id = $('#store_id').val();
        
        if(!from_date || !to_date) {
            alert('Please select both From Date and To Date');
            return;
        }
        
        $('#welcome-message').hide();
        $('#cash-flow-content').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</div>');
        $('#report-container').show();
        
        $.ajax({
            url: base_url + 'reports/get_cash_flow_statement',
            type: 'POST',
            data: {
                from_date: from_date,
                to_date: to_date,
                store_id: store_id
            },
            dataType: 'json',
            success: function(response) {
                if(response.error) {
                    $('#cash-flow-content').html('<div class="alert alert-danger">' + response.message + '</div>');
                } else {
                    currentReportData = response;
                    displayCashFlowStatement(response);
                }
            },
            error: function() {
                $('#cash-flow-content').html('<div class="alert alert-danger">Error generating cash flow statement</div>');
            }
        });
    }
    
    function displayCashFlowStatement(data) {
        var html = '<div class="report-title">CASH FLOW STATEMENT</div>';
        html += '<div class="report-period" id="report-period">Period: ' + $('#from_date').val() + ' to ' + $('#to_date').val() + '</div>';
        
        html += '<table class="cash-flow-table" id="cash-flow-data">';
        html += '<thead>';
        html += '<tr>';
        html += '<th style="width: 60%;">Description</th>';
        html += '<th style="width: 40%; text-align: right;">Amount</th>';
        html += '</tr>';
        html += '</thead>';
        html += '<tbody>';
        
        // Operating Activities
        html += '<tr class="section-header"><td colspan="2"><strong>OPERATING ACTIVITIES</strong></td></tr>';
        html += '<tr><td>Cash Sales</td><td class="text-right">' + formatCurrency(data.operating['Cash Sales'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr><td>Credit Sales</td><td class="text-right">' + formatCurrency(data.operating['Credit Sales'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr><td>Total Sales Revenue</td><td class="text-right">' + formatCurrency(data.operating['Total Sales Revenue'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr><td>Purchase Payments</td><td class="text-right">' + formatCurrency(data.operating['Purchase Payments'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr><td>Expense Payments</td><td class="text-right">' + formatCurrency(data.operating['Expense Payments'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr><td>Tax Payments</td><td class="text-right">' + formatCurrency(data.operating['Tax Payments'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr class="total-row"><td><strong>Net Operating Cash Flow</strong></td><td class="text-right"><strong>' + formatCurrency(data.operating['Net Operating Cash Flow'], data.base_currency.symbol, data.base_currency.position) + '</strong></td></tr>';
        
        // Investing Activities
        html += '<tr class="section-header"><td colspan="2"><strong>INVESTING ACTIVITIES</strong></td></tr>';
        html += '<tr><td>Asset Purchases</td><td class="text-right">' + formatCurrency(data.investing['Asset Purchases'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr class="total-row"><td><strong>Net Investing Cash Flow</strong></td><td class="text-right"><strong>' + formatCurrency(data.investing['Net Investing Cash Flow'], data.base_currency.symbol, data.base_currency.position) + '</strong></td></tr>';
        
        // Financing Activities
        html += '<tr class="section-header"><td colspan="2"><strong>FINANCING ACTIVITIES</strong></td></tr>';
        html += '<tr><td>Loan Receipts</td><td class="text-right">' + formatCurrency(data.financing['Loan Receipts'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr><td>Loan Payments</td><td class="text-right">' + formatCurrency(data.financing['Loan Payments'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr class="total-row"><td><strong>Net Financing Cash Flow</strong></td><td class="text-right"><strong>' + formatCurrency(data.financing['Net Financing Cash Flow'], data.base_currency.symbol, data.base_currency.position) + '</strong></td></tr>';
        
        // Summary
        html += '<tr class="section-header"><td colspan="2"><strong>SUMMARY</strong></td></tr>';
        html += '<tr><td>Net Cash Flow</td><td class="text-right">' + formatCurrency(data.summary['Net Cash Flow'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr><td>Opening Balance</td><td class="text-right">' + formatCurrency(data.summary['Opening Balance'], data.base_currency.symbol, data.base_currency.position) + '</td></tr>';
        html += '<tr class="grand-total-row"><td><strong>Closing Balance</strong></td><td class="text-right"><strong>' + formatCurrency(data.summary['Closing Balance'], data.base_currency.symbol, data.base_currency.position) + '</strong></td></tr>';
        
        html += '</tbody>';
        html += '</table>';
        
        $('#cash-flow-content').html(html);
    }
    
    function formatCurrency(amount, symbol, position) {
        var formatted = parseFloat(amount).toFixed(2);
        return position == 'before' ? symbol + formatted : formatted + symbol;
    }
    
    function exportToExcel() {
        if (!$('#cash-flow-data').length) {
            alert('Please generate the report first before exporting.');
            return;
        }
        
        $('#cash-flow-data').tableExport({
            type: 'excel',
            fileName: 'Cash_Flow_Statement_' + new Date().toISOString().slice(0,10),
            ignoreColumn: []
        });
    }
    
    function printCashFlowReport() {
        if (!$('#cash-flow-data').length) {
            alert('Please generate the cash flow statement first before printing.');
            return;
        }
        
        var companyName = '<?php echo $store_name ? $store_name : "NCS Billing Book"; ?>';
        var companyAddress = '<?php echo $store_address; ?>';
        var companyPhone = '<?php echo $store_phone; ?>';
        var companyEmail = '<?php echo $store_email; ?>';
        
        var fromDate = $('#from_date').val();
        var toDate = $('#to_date').val();
        var reportPeriod = 'Period: ' + fromDate + ' to ' + toDate;
        
        // Get table data
        var table = document.getElementById('cash-flow-data');
        var tableData = [];
        
        // Get all rows
        var rows = table.getElementsByTagName('tr');
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i];
            var cells = row.getElementsByTagName('td');
            if (cells.length >= 2) {
                var description = cells[0].textContent || cells[0].innerText;
                var amount = cells[1].textContent || cells[1].innerText;
                tableData.push([description, amount]);
            }
        }
        
        // Build print content
        var printContent = '<div class="printable">';
        printContent += '<div class="company-header">';
        printContent += '<div class="company-name">' + companyName + '</div>';
        printContent += '<div class="company-details">' + companyAddress + '</div>';
        printContent += '<div class="company-details">' + companyPhone + ' | ' + companyEmail + '</div>';
        printContent += '</div>';
        
        printContent += '<div class="report-title">CASH FLOW STATEMENT</div>';
        printContent += '<div class="report-period">' + reportPeriod + '</div>';
        
        printContent += '<table class="cash-flow-table" style="width: 100%; border-collapse: collapse;">';
        printContent += '<thead><tr class="bg-blue"><th style="width: 60%; padding: 8px; border: 1px solid #000;">Description</th><th style="width: 40%; text-align: right; padding: 8px; border: 1px solid #000;">Amount</th></tr></thead>';
        printContent += '<tbody>';
        
        for (var j = 0; j < tableData.length; j++) {
            var rowClass = '';
            if (tableData[j][0].includes('OPERATING ACTIVITIES') || tableData[j][0].includes('INVESTING ACTIVITIES') || tableData[j][0].includes('FINANCING ACTIVITIES') || tableData[j][0].includes('SUMMARY')) {
                rowClass = 'class="section-header"';
            } else if (tableData[j][0].includes('Net Operating Cash Flow') || tableData[j][0].includes('Net Investing Cash Flow') || tableData[j][0].includes('Net Financing Cash Flow')) {
                rowClass = 'class="total-row"';
            } else if (tableData[j][0].includes('Closing Balance')) {
                rowClass = 'class="grand-total-row"';
            }
            
            printContent += '<tr ' + rowClass + '>';
            printContent += '<td style="padding: 8px; border: 1px solid #000;">' + tableData[j][0] + '</td>';
            printContent += '<td style="padding: 8px; border: 1px solid #000; text-align: right;">' + tableData[j][1] + '</td>';
            printContent += '</tr>';
        }
        
        printContent += '</tbody></table>';
        printContent += '<div style="margin-top: 30px; text-align: center; font-size: 12px;">Generated on: ' + new Date().toLocaleString() + '</div>';
        printContent += '</div>';
        
        // Open print window
        var printWindow = window.open('', '_blank');
        printWindow.document.write('<html><head><title>Cash Flow Statement - ' + companyName + '</title>');
        printWindow.document.write('<style>body { font-family: Arial, sans-serif; margin: 20px; } .printable { width: 100%; } .company-header { text-align: center; margin-bottom: 20px; } .company-name { font-size: 24px; font-weight: bold; margin-bottom: 5px; } .company-details { font-size: 12px; margin-bottom: 10px; } .report-title { font-size: 18px; font-weight: bold; text-align: center; margin: 20px 0; } .report-period { font-size: 12px; margin-bottom: 15px; } .section-header { background-color: #3c8dbc; color: white; font-weight: bold; padding: 8px; } .total-row { background-color: #f39c12; color: white; font-weight: bold; } .grand-total-row { background-color: #00a65a; color: white; font-weight: bold; font-size: 16px; } .text-right { text-align: right; } .text-center { text-align: center; } .text-bold { font-weight: bold; } .table { border-collapse: collapse; width: 100%; } .table th, .table td { border: 1px solid #000; padding: 8px; }</style>');
        printWindow.document.write('</head><body>');
        printWindow.document.write(printContent);
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        
        // Print after content loads
        printWindow.onload = function() {
            printWindow.focus();
            printWindow.print();
            printWindow.close();
        };
    }
    </script>
    
    <!-- Make sidebar menu highlighter/selector -->
    <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
    
    <?php include"comman/code_js_sound.php"; ?>
    <?php include"comman/code_js.php"; ?>
    
    <!-- Add the sidebar's background. This div must be placed
          immediately after the control sidebar -->
       <div class="control-sidebar-bg"></div>
    </div>
    <!-- ./wrapper -->
</body>
</html>