<?php
// Get store information for print functions
$store = get_store_details();
$store_name = get_store_name();

// Ensure we have a proper store name
if (empty($store_name) || $store_name === true || $store_name === 1) {
    $store_name = isset($store->store_name) ? $store->store_name : 'NCS Billing Book';
}

$store_address = isset($store->address) ? $store->address : "123 Main Street, New York, NY 10001";
$store_phone = isset($store->mobile) ? "Phone: " . $store->mobile : "Phone: 9999999999";
$store_email = isset($store->email) ? "Email: " . $store->email : "Email: billingbook@email.com";
?>
<!DOCTYPE html>
<html>
<head>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<!-- </copy> -->  
</head>
   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?=$page_title;?>
                  <small></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                  <li class="active"><?=$page_title;?></li>
               </ol>
            </section>
            <!-- Main content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        <div class="box-header with-border">
                           <h3 class="box-title">Please Enter Valid Information</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="report-form" onkeypress="return event.keyCode != 13;">
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="form-group">
                                 <!-- Store Code -->
                                 <?php if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>get_current_store_id(),'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true')); }else{
                                    echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
                                    }?>
                                 <!-- Store Code end -->
                                 <label for="customer_id" class="col-sm-2 control-label"><?= $this->lang->line('customer_name'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="customer_id" name="customer_id" >
                                    </select>
                                    <span id="customer_id_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                              <div class="form-group">
                                 <label for="from_date" class="col-sm-2 control-label"><?= $this->lang->line('from_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="from_date" name="from_date" value="<?php echo show_date(date('d-m-Y'));?>" >
                                    </div>
                                    <span id="Sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="to_date" class="col-sm-2 control-label"><?= $this->lang->line('to_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="to_date" name="to_date" value="<?php echo show_date(date('d-m-Y'))?>" >
                                    </div>
                                    <span id="Sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                              <div class="form-group">
                                 <label for="payment_type" class="col-sm-2 control-label"><?= $this->lang->line('payment_type'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2" id='payment_type' name="payment_type">
                                       <option value="">Select</option>
                                        <?= get_payment_types_select_list(null,get_current_store_id());?>
                                      </select>
                                    <span id="payment_type_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="created_by" class="col-sm-2 control-label"><?= $this->lang->line('user'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="created_by" name="created_by">
                                       
                                       <?= get_users_select_list($this->session->userdata("role_id"),get_current_store_id());?>
                                    </select>
                                    <span id="created_by_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-body -->
                           <div class="box-footer">
                              <div class="col-sm-8 col-sm-offset-2 text-center">
                                 <div class="col-md-3 col-md-offset-3">
                                    <button type="button" id="view" class=" btn btn-block btn-success" title="Save Data">Show</button>
                                 </div>
                                    <div class="col-sm-2">
                                       <button type="button" class="btn btn-block btn-info" onclick="printReport()" title="Print Report">
                                          <i class="fa fa-print"></i> Print A4
                                       </button>
                                    </div>
                                    <div class="col-sm-2">
                                       <a href="<?=base_url('dashboard');?>">
                                          <button type="button" class="btn btn-block btn-warning close_btn" title="Go Dashboard">Close</button>
                                       </a>
                                    </div>
                              </div>
                           </div>
                           <!-- /.box-footer -->
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>
                  <!--/.col (right) -->
               </div>
               <!-- /.row -->
            </section>
            <!-- /.content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <div class="box">
                        <div class="box-header">
                           <h3 class="box-title">Records Table</h3>
                           <?php $this->load->view('components/export_btn',array('tableId' => 'report-data'));?>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                           <table class="table table-bordered table-hover " id="report-data" >
                              <thead>
                                 <tr class="bg-blue">
                                    <th style="">#</th>
                                    <th style="">Date</th>
                                    <th style="">Reference</th>
                                    <th style="">Description</th>
                                    <th style="">Qty</th>
                                    <th style="">Bill Amount<br><small>(System & Original Currency)</small></th>
                                    <th style="">Payment Amount<br><small>(System & Original Currency)</small></th>
                                    <th style="">Running Balance<br><small>(Customer & System Currency)</small></th>
                                    <th style="">Currency</th>
                                 </tr>
                              </thead>
                              <tbody id="tbodyid">
                              </tbody>
                           </table>
                        </div>
                        <!-- /.box-body -->
                     </div>
                     <!-- /.box -->
                  </div>
               </div>
            </section>
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
<!-- TABLES CODE -->
<?php include"comman/code_js.php"; ?>

<!-- Print-specific CSS -->
<style>
@media print {
    body {
        margin: 0;
        padding: 20px;
        font-family: Arial, sans-serif;
        font-size: 12px;
        line-height: 1.4;
        color: #000;
        background: white;
    }
    
    .no-print {
        display: none !important;
    }
    
    .print-header {
        text-align: center;
        margin-bottom: 30px;
        border-bottom: 2px solid #333;
        padding-bottom: 20px;
    }
    
    .print-header h1 {
        font-size: 24px;
        font-weight: bold;
        margin: 0 0 10px 0;
        color: #333;
    }
    
    .print-header .company-info {
        font-size: 14px;
        color: #666;
        margin: 5px 0;
    }
    
    .print-header .report-title {
        font-size: 18px;
        font-weight: bold;
        margin: 15px 0 10px 0;
        color: #2c3e50;
    }
    
    .print-header .report-period {
        font-size: 12px;
        color: #666;
        margin: 5px 0;
    }
    
    .print-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    
    .print-table th {
        background-color: #34495e !important;
        color: white !important;
        font-weight: bold;
        padding: 8px 6px;
        text-align: center;
        border: 1px solid #333;
        font-size: 11px;
    }
    
    .print-table td {
        padding: 6px;
        border: 1px solid #333;
        font-size: 11px;
        vertical-align: top;
    }
    
    .print-table tr:nth-child(even) {
        background-color: #f8f9fa;
    }
    
    .print-table .text-right {
        text-align: right;
    }
    
    .print-table .text-center {
        text-align: center;
    }
    
    .print-table .text-left {
        text-align: left;
    }
    
    .print-totals {
        margin-top: 20px;
        font-weight: bold;
        background-color: #ecf0f1;
        padding: 10px;
        border: 1px solid #bdc3c7;
    }
    
    .print-footer {
        margin-top: 30px;
        text-align: center;
        font-size: 10px;
        color: #666;
        border-top: 1px solid #ccc;
        padding-top: 10px;
    }
    
    .page-break {
        page-break-before: always;
    }
    
    @page {
        margin: 1cm;
        size: A4;
    }
}
</style>
      <!-- TABLE EXPORT CODE -->
      <?php include"comman/code_js_export.php"; ?>
      <script src="<?php echo $theme_link; ?>js/sheetjs.js" type="text/javascript"></script>
      <script src="<?php echo $theme_link; ?>js/ajaxselect/customer_select_ajax.js"></script>  
      <script type="text/javascript">
         //Customer Selection Box Search
         function getCustomerSelectionId() {
           return '#customer_id';
         }
         //Customer Selection Box Search - END
      </script>
      
      <script type="text/javascript">
         $("#view").on("click",function(){
         
         
           var from_date=document.getElementById("from_date").value;
           var to_date=document.getElementById("to_date").value;
           var customer_id=document.getElementById("customer_id").value;
           var payment_type=document.getElementById("payment_type").value;
           var store_id=document.getElementById("store_id").value;
           var created_by=document.getElementById("created_by").value;

         if(from_date == "")
             {
                 toastr["warning"]("Select From Date!");
                 document.getElementById("from_date").focus();
                 return;
             }
          
          if(to_date == "")
             {
                 toastr["warning"]("Select To Date!");
                 document.getElementById("to_date").focus();
                 return;
             }
         
           
               $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
               $.post("sales_and_payments_report",{created_by:created_by,store_id:store_id,payment_type:payment_type,customer_id:customer_id,from_date:from_date,to_date:to_date},function(result){
                 //alert(result);
                   setTimeout(function() {
                    $("#tbodyid").empty().append(result);
                    
                    // Store customer data for printing
                    var customerName = $('#customer_id option:selected').text();
                    if (customerName && customerName !== '-Select-') {
                        window.currentReportData = {
                            customer_name: customerName,
                            from_date: from_date,
                            to_date: to_date
                        };
                    }
                    
                    $(".overlay").remove();
                   }, 0);
                  }); 
             
         
         });
         
         
      </script>
      <script type="text/javascript">
         var base_url=$("#base_url").val();
         
         // Professional A4 Print Function
         function printReport() {
             // Get current report data
             var reportData = window.currentReportData;
             if (!reportData || !reportData.customer_name) {
                 alert('Please generate the report first before printing.');
                 return;
             }
             
             // Create print window
             var printWindow = window.open('', '_blank', 'width=800,height=600');
             
             // Get company information dynamically
             var companyName = '<?php echo $store_name ? $store_name : "NCS Billing Book"; ?>';
             var companyAddress = '<?php echo $store_address; ?>';
             var companyPhone = '<?php echo $store_phone; ?>';
             var companyEmail = '<?php echo $store_email; ?>';
             
             // Get current date
             var currentDate = new Date().toLocaleDateString();
             
             // Get report period
             var fromDate = $('#from_date').val() || 'All Time';
             var toDate = $('#to_date').val() || 'All Time';
             var reportPeriod = fromDate + ' to ' + toDate;
             
             // Build print content
             var printContent = `
                 <!DOCTYPE html>
                 <html>
                 <head>
                     <title>Sales & Payments Report - ${reportData.customer_name}</title>
                     <style>
                         body { font-family: Arial, sans-serif; font-size: 12px; margin: 0; padding: 30px 20px; }
                         .print-header { text-align: center; margin-bottom: 30px; margin-top: 20px; border-bottom: 2px solid #333; padding-bottom: 20px; }
                         .print-header h1 { font-size: 24px; font-weight: bold; margin: 0 0 10px 0; color: #333; }
                         .print-header .company-info { font-size: 14px; color: #666; margin: 5px 0; }
                         .print-header .report-title { font-size: 18px; font-weight: bold; margin: 15px 0 10px 0; color: #2c3e50; }
                         .print-header .report-period { font-size: 12px; color: #666; margin: 5px 0; }
                         .print-table { width: 100%; border-collapse: collapse; margin-top: 20px; }
                         .print-table th { background-color: #34495e; color: white; font-weight: bold; padding: 8px 6px; text-align: center; border: 1px solid #333; font-size: 11px; }
                         .print-table td { padding: 6px; border: 1px solid #333; font-size: 11px; vertical-align: top; }
                         .print-table tr:nth-child(even) { background-color: #f8f9fa; }
                         .print-table .text-right { text-align: right; }
                         .print-table .text-center { text-align: center; }
                         .print-table .text-left { text-align: left; }
                         .print-footer { margin-top: 30px; text-align: center; font-size: 10px; color: #666; border-top: 1px solid #ccc; padding-top: 10px; }
                         @page { margin: 1.5cm; size: A4; }
                     </style>
                 </head>
                 <body>
                     <div class="print-header">
                         <h1>${companyName}</h1>
                         <div class="company-info">${companyAddress}</div>
                         <div class="company-info">${companyPhone}</div>
                         <div class="company-info">${companyEmail}</div>
                         <div class="report-title">Sales & Payments Report</div>
                         <div class="report-period"><strong>Customer:</strong> ${reportData.customer_name}</div>
                         <div class="report-period"><strong>Period:</strong> ${reportPeriod}</div>
                         <div class="report-period"><strong>Generated:</strong> ${currentDate}</div>
                     </div>
                     
                     <table class="print-table">
                         <thead>
                             <tr>
                                 <th>#</th>
                                 <th>Date</th>
                                 <th>Reference</th>
                                 <th>Description</th>
                                 <th>Qty</th>
                                 <th>Bill Amount<br><small>(System & Original Currency)</small></th>
                                 <th>Payment Amount<br><small>(System & Original Currency)</small></th>
                                 <th>Running Balance<br><small>(Customer & System Currency)</small></th>
                                 <th>Currency</th>
                             </tr>
                         </thead>
                         <tbody>
                             ${$('#tbodyid').html()}
                         </tbody>
                     </table>
                     
                     <div class="print-footer">
                         <p>This report was generated on ${currentDate} by ${companyName} System</p>
                         <p>For any queries, please contact us at ${companyEmail}</p>
                     </div>
                 </body>
                 </html>
             `;
             
             // Write content and print
             printWindow.document.write(printContent);
             printWindow.document.close();
             
             // Wait for content to load, then print
             printWindow.onload = function() {
                 printWindow.focus();
                 printWindow.print();
                 printWindow.close();
             };
         }
         
         $("#store_id").on("change",function(){
           

               load_payment_types_list();

               load_users();
               
               autoLoadFirstCustomer();

         });

         function load_payment_types_list(){
           var store_id=$("#store_id").val();
           $.post(base_url+"sales/get_payment_types_select_list",{store_id:store_id},function(result){
                result='<option value="">All</option>'+result;
                $("#payment_type").html('').append(result).select2();
            });
          }

          function load_users(){
         var store_id=$("#store_id").val();
          $.post(base_url+"sales/get_users_select_list",{store_id:store_id},function(result){
             // result='<option value="">All</option>'+result;
              $("#created_by").html('').append(result).select2();
          });
        }

      </script>
      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
   </body>
</html>
