<!DOCTYPE html>
<html>
<head>
    <?php $this->load->view('comman/code_css.php');?>
    <title><?= $page_title; ?></title>
    <style>
        .transaction-details {
            margin: 20px;
        }
        .table-responsive {
            max-height: 600px;
            overflow-y: auto;
        }
        .record-count {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .back-btn {
            margin-bottom: 20px;
        }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php $this->load->view('sidebar');?>
        
        <div class="content-wrapper">
            <section class="content-header">
                <h1><?= $page_title; ?></h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?php echo $base_url; ?>store_profile">Store Profile</a></li>
                    <li class="active"><?= $page_title; ?></li>
                </ol>
            </section>
            
            <section class="content">
                <div class="transaction-details">
                    <div class="back-btn">
                        <button class="btn btn-primary" onclick="window.close()">
                            <i class="fa fa-arrow-left"></i> Back
                        </button>
                    </div>
                    
                    <div class="record-count">
                        <h4><i class="fa fa-database"></i> Table: <code><?= $table_name; ?></code></h4>
                        <p><strong>Total Records:</strong> <span class="badge badge-info"><?= $record_count; ?></span></p>
                        <p><strong>Store ID:</strong> <?= $store_id; ?></p>
                    </div>
                    
                    <?php if (!empty($records)): ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover">
                                <thead class="bg-primary text-white">
                                    <tr>
                                        <?php foreach (array_keys((array)$records[0]) as $column): ?>
                                            <th><?= ucfirst(str_replace('_', ' ', $column)); ?></th>
                                        <?php endforeach; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($records as $record): ?>
                                        <tr>
                                            <?php foreach ((array)$record as $value): ?>
                                                <td>
                                                    <?php 
                                                    if (is_numeric($value) && strlen($value) > 10) {
                                                        echo date('Y-m-d H:i:s', $value);
                                                    } else {
                                                        echo htmlspecialchars($value);
                                                    }
                                                    ?>
                                                </td>
                                            <?php endforeach; ?>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No records found in this table.
                        </div>
                    <?php endif; ?>
                </div>
            </section>
        </div>
    </div>
    
    <?php $this->load->view('comman/code_js.php');?>
</body>
</html>
