<!DOCTYPE html>
<html>
   
   <head>
  <!-- TABLES CSS CODE -->
  <?php include"comman/code_css.php"; ?>
  <!-- </copy> -->  
  </head>

   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?= $this->lang->line('site_settings'); ?>
                  <small><?= $this->lang->line('add_or_update'); ?> <?= $this->lang->line('site_settings'); ?></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                  <li class="active">Site Settings</li>
               </ol>
            </section>
            
            <!-- Main content -->
  <?= form_open('#', array('class' => 'form-horizontal', 'id' => 'site-form', 'enctype'=>'multipart/form-data', 'method'=>'POST'));?>
            <section class="content">
               <div class="row">
                  <!-- ********** ALERT MESSAGE START******* -->
                <?php include"comman/code_flashdata.php"; ?>
                  <!-- ********** ALERT MESSAGE END******* -->

                  <div class="col-md-12">
                     <!-- Demo Mode Alert for Site Settings -->
                     <?php if(demo_app()){ ?>
                     <div class="alert alert-warning text-center">
                        <i class="fa fa-exclamation-triangle"></i>
                        <strong>Demo Mode Active:</strong> Site Settings cannot be modified or saved in demo mode. 
                        <a href="https://nanzige.gumroad.com/l/billingbook" target="_blank" class="btn btn-sm btn-danger" style="margin-left: 10px;">
                           <i class="fa fa-shopping-cart"></i> Buy Now to Enable
                        </a>
                     </div>
                     <?php } ?>
                     
                     <!-- Custom Tabs -->
                     <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs">
                           <li class="active"><a href="#tab_1" data-toggle="tab"><?= $this->lang->line('site'); ?></a></li>
                           <li><a href="#tab_2" data-toggle="tab">System Cache</a></li>
                        </ul>
                        <div class="tab-content">
                           <div class="tab-pane active" id="tab_1">
                              <div class="row">
                                 <!-- right column -->
                                 <div class="col-md-12">
                                    <!-- form start -->
                                       <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                                       <div class="box-body">
                                          <div class="row">
                                             <div class="col-md-5">
                                                <div class="form-group">
                                                   <label for="site_name" class="col-sm-4 control-label"><?= $this->lang->line('site_name'); ?><label class="text-danger">*</label></label>
                                                   <div class="col-sm-8">
                                                      <input type="text" class="form-control" id="site_name" name="site_name" placeholder="" onkeyup="shift_cursor(event,'mobile')" value="<?php print $site_name; ?>" <?php echo demo_app() ? 'disabled' : ''; ?>>
                                                      <span id="site_name_msg" style="display:none" class="text-danger"></span>
                                                   </div>
                                                </div>
                                             </div>
                                             <div class="col-md-5">
                                                <div class="form-group">
                                                   <label for="address" class="col-sm-4 control-label"><?= $this->lang->line('site_logo'); ?></label>
                                                   <div class="col-sm-8">
                                                      <input type="file" id="logo" name="logo" <?php echo demo_app() ? 'disabled' : ''; ?>>
                                                      <span id="logo_msg" style="display:block;" class="text-danger">Max Width/Height: 300px * 300px & Size: 300px </span>
                                                   </div>
                                                </div>
                                                <?php 
                                                if(empty($logo)){
                                                  $logo = base_url('uploads/no_logo/nologo.png');
                                                }
                                                else{
                                                  $logo = base_url($logo);
                                                }
                                                ?>
                                                <div class="form-group">
                                                   <div class="col-sm-8 col-sm-offset-4">
                                                      <img class='img-responsive' style='border:3px solid #d2d6de;' src="<?php echo $logo;?>">
                                                   </div>
                                                </div>
                                             </div>
                                             <!-- ########### -->
                                          </div>
                                       </div>
                                       <!-- /.box-body -->
                                       <!-- /.box-footer -->
                                    
                                 </div>
                                 <!--/.col (right) -->
                              </div>
                              <!-- /.row -->
                           </div>
                           <!-- /.tab-pane -->
                           
                           <!-- Cache Management Tab -->
                           <div class="tab-pane" id="tab_2">
                              <div class="row">
                                 <div class="col-md-12">
                                    <div class="box box-info">
                                       <div class="box-header with-border">
                                          <h3 class="box-title">
                                             <i class="fa fa-database"></i> System Cache Management
                                          </h3>
                                          <div class="box-tools pull-right">
                                             <button type="button" class="btn btn-box-tool" onclick="refreshCacheStatus()" title="Refresh Status">
                                                <i class="fa fa-refresh"></i>
                                             </button>
                                          </div>
                                       </div>
                                       <div class="box-body">
                                          <!-- Cache Status Display -->
                                          <div id="cache-status-container">
                                             <div class="text-center">
                                                <i class="fa fa-spinner fa-spin fa-2x"></i>
                                                <p>Loading cache status...</p>
                                             </div>
                                          </div>
                                          
                                          <!-- Cache Actions -->
                                          <div class="row" style="margin-top: 20px;">
                                             <div class="col-md-6">
                                                <div class="info-box bg-yellow">
                                                   <span class="info-box-icon"><i class="fa fa-info-circle"></i></span>
                                                   <div class="info-box-content">
                                                      <span class="info-box-text" style="font-size: 12px;">Cache Information</span>
                                                      <span class="info-box-number" id="total-cache-files" style="font-size: 18px;">-</span>
                                                      <div class="progress" style="height: 3px;">
                                                         <div class="progress-bar" style="width: 0%"></div>
                                                      </div>
                                                      <span class="progress-description" id="total-cache-size" style="font-size: 11px;">-</span>
                                                   </div>
                                                </div>
                                             </div>
                                             <div class="col-md-6">
                                                <div class="info-box bg-red">
                                                   <span class="info-box-icon"><i class="fa fa-trash"></i></span>
                                                   <div class="info-box-content">
                                                      <span class="info-box-text" style="font-size: 12px;">Cache Actions</span>
                                                      <span class="info-box-number" style="font-size: 14px;">Clear All</span>
                                                      <div class="progress" style="height: 3px;">
                                                         <div class="progress-bar" style="width: 100%"></div>
                                                      </div>
                                                      <span class="progress-description" style="font-size: 11px;">
                                                         <button type="button" class="btn btn-danger btn-xs" onclick="clearSystemCache()" id="clear-cache-btn">
                                                            <i class="fa fa-trash"></i> Clear Cache
                                                         </button>
                                                      </span>
                                                   </div>
                                                </div>
                                             </div>
                                          </div>
                                          
                                          <!-- Cache Details Table -->
                                          <div class="table-responsive" style="margin-top: 20px;">
                                             <table class="table table-bordered table-striped" id="cache-details-table">
                                                <thead>
                                                   <tr>
                                                      <th>Cache Type</th>
                                                      <th>Path</th>
                                                      <th>Files Count</th>
                                                      <th>Size</th>
                                                      <th>Status</th>
                                                   </tr>
                                                </thead>
                                                <tbody id="cache-details-body">
                                                   <!-- Dynamic content will be loaded here -->
                                                </tbody>
                                             </table>
                                          </div>
                                          
                                          <!-- Last Cache Clear Info -->
                                          <div class="alert alert-info" id="last-cache-clear" style="display: none;">
                                             <i class="fa fa-info-circle"></i>
                                             <strong>Last Cache Clear:</strong> <span id="last-clear-time">-</span>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <!-- /.tab-pane -->
                        </div>
                        <!-- /.tab-content -->
                     </div>
                     <!-- nav-tabs-custom -->
                     <div>
                        <div class="col-sm-8 col-sm-offset-2 text-center">
                           <center>
                              <?php
                                 if($site_name!=""){
                                      $btn_name="Update";
                                      $btn_id="update";
                                      ?>
                              <input type="hidden" name="q_id" id="q_id" value="<?php echo $q_id;?>"/>
                              <?php
                                 }
                                 else{
                                     $btn_name="Save";
                                     $btn_id="save";
                                 }
                                 
                                 ?>
                              <div class="col-md-3 col-md-offset-3">
                                 <button type="button" id="<?php echo $btn_id;?>" class=" btn btn-block btn-success" title="Save Data" <?php echo demo_app() ? 'disabled' : ''; ?>><?php echo $btn_name;?></button>
                              </div>
                              <div class="col-sm-3">
                                <a href="<?=base_url('dashboard');?>">
                                 <button type="button" class="col-sm-3 btn btn-block btn-warning close_btn" title="Go Dashboard">Close</button>
                               </a>
                              </div>
                           </center>
                        </div>
                     </div>
                  </div>
                  <!-- /.col -->
               </div>
               <!-- /.row -->
            </section>
            <!-- /.content -->
            <?= form_close(); ?>
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      
      <?php include'comman/code_js_language.php'; ?>

      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
      <!-- TABLES CODE -->
      <?php include"comman/code_js.php"; ?>

      <script type="text/javascript">
         $(document).submit(function(event) {
           event.preventDefault();
           if($("#update").length){
             $("#update").trigger('click');
           }
         });
         
         // Cache Management Functions
         $(document).ready(function() {
            // Load cache status when cache tab is clicked
            $('a[href="#tab_2"]').on('click', function() {
               refreshCacheStatus();
            });
         });
         
         function refreshCacheStatus() {
            $('#cache-status-container').html('<div class="text-center"><i class="fa fa-spinner fa-spin fa-2x"></i><p>Loading cache status...</p></div>');
            
            $.ajax({
               url: base_url + 'site/cache_status',
               type: 'POST',
               dataType: 'json',
               success: function(response) {
                  if(response.success) {
                     displayCacheStatus(response.cache_info);
                  } else {
                     $('#cache-status-container').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ' + response.message + '</div>');
                  }
               },
               error: function() {
                  $('#cache-status-container').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> Failed to load cache status</div>');
               }
            });
         }
         
         function displayCacheStatus(cacheInfo) {
            var totalFiles = 0;
            var totalSize = 0;
            var tableRows = '';
            
            // Calculate totals and build table rows
            for(var type in cacheInfo) {
               var info = cacheInfo[type];
               totalFiles += info.files_count;
               
               // Convert size to bytes for calculation
               var sizeInBytes = parseFloat(info.size) * getSizeMultiplier(info.size);
               totalSize += sizeInBytes;
               
               var statusClass = info.files_count > 0 ? 'success' : 'default';
               var statusText = info.files_count > 0 ? 'Active' : 'Empty';
               
               tableRows += '<tr>';
               tableRows += '<td><strong>' + type.replace('_', ' ').toUpperCase() + '</strong></td>';
               tableRows += '<td><code>' + info.path + '</code></td>';
               tableRows += '<td><span class="badge bg-blue">' + info.files_count + '</span></td>';
               tableRows += '<td><span class="badge bg-green">' + info.size + '</span></td>';
               tableRows += '<td><span class="badge bg-' + statusClass + '">' + statusText + '</span></td>';
               tableRows += '</tr>';
            }
            
            // Update totals
            $('#total-cache-files').text(totalFiles);
            $('#total-cache-size').text(formatBytes(totalSize));
            
            // Update table
            $('#cache-details-body').html(tableRows);
            
            // Update status container with auto-hide
            var statusHtml = '<div class="alert alert-success alert-dismissible" id="cache-status-alert">';
            statusHtml += '<i class="fa fa-check-circle"></i> ';
            statusHtml += '<strong>Cache Status Loaded Successfully!</strong> ';
            statusHtml += 'Found ' + totalFiles + ' cache files totaling ' + formatBytes(totalSize);
            statusHtml += '<button type="button" class="close" data-dismiss="alert" aria-label="Close">';
            statusHtml += '<span aria-hidden="true">&times;</span>';
            statusHtml += '</button>';
            statusHtml += '</div>';
            $('#cache-status-container').html(statusHtml);
            
            // Auto-hide the status message after 3 seconds
            setTimeout(function() {
                $('#cache-status-alert').fadeOut(500, function() {
                    $(this).remove();
                });
            }, 3000);
         }
         
         function clearSystemCache() {
            if(!confirm('Are you sure you want to clear all system cache? This action cannot be undone.')) {
               return;
            }
            
            var $btn = $('#clear-cache-btn');
            var originalText = $btn.html();
            
            // Show loading state
            $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Clearing...');
            
            $.ajax({
               url: base_url + 'site/clear_cache',
               type: 'POST',
               dataType: 'json',
               success: function(response) {
                  if(response.success) {
                     // Show success message
                     var successHtml = '<div class="alert alert-success">';
                     successHtml += '<i class="fa fa-check-circle"></i> ';
                     successHtml += '<strong>' + response.message + '</strong><br>';
                     successHtml += '<strong>Cleared Items:</strong><ul>';
                     
                     for(var i = 0; i < response.cleared_items.length; i++) {
                        successHtml += '<li>' + response.cleared_items[i] + '</li>';
                     }
                     
                     successHtml += '</ul>';
                     
                     if(response.errors.length > 0) {
                        successHtml += '<strong>Errors:</strong><ul>';
                        for(var j = 0; j < response.errors.length; j++) {
                           successHtml += '<li class="text-warning">' + response.errors[j] + '</li>';
                        }
                        successHtml += '</ul>';
                     }
                     
                     successHtml += '<small class="text-muted">Cleared at: ' + response.timestamp + '</small>';
                     successHtml += '<button type="button" class="close" data-dismiss="alert" aria-label="Close">';
                     successHtml += '<span aria-hidden="true">&times;</span>';
                     successHtml += '</button>';
                     successHtml += '</div>';
                     
                     $('#cache-status-container').html(successHtml);
                     
                     // Auto-hide the success message after 5 seconds (longer for important info)
                     setTimeout(function() {
                         $('#cache-status-container .alert').fadeOut(500, function() {
                             $(this).remove();
                         });
                     }, 5000);
                     
                     // Update last clear time
                     $('#last-clear-time').text(response.timestamp);
                     $('#last-cache-clear').show();
                     
                     // Refresh cache status after a short delay
                     setTimeout(function() {
                        refreshCacheStatus();
                     }, 2000);
                     
                  } else {
                     $('#cache-status-container').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ' + response.message + '</div>');
                  }
               },
               error: function() {
                  $('#cache-status-container').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> Failed to clear cache</div>');
               },
               complete: function() {
                  // Restore button state
                  $btn.prop('disabled', false).html(originalText);
               }
            });
         }
         
         // Helper functions
         function getSizeMultiplier(sizeStr) {
            var unit = sizeStr.replace(/[0-9.]/g, '').trim();
            switch(unit) {
               case 'B': return 1;
               case 'KB': return 1024;
               case 'MB': return 1024 * 1024;
               case 'GB': return 1024 * 1024 * 1024;
               case 'TB': return 1024 * 1024 * 1024 * 1024;
               default: return 1;
            }
         }
         
         function formatBytes(bytes) {
            if(bytes === 0) return '0 B';
            var k = 1024;
            var sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
            var i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
         }
      </script>
      <script src="<?php echo $theme_link; ?>js/site-settings.js"></script>
      
      <!-- Cache Management Styling -->
      <style>
        /* Cache Cards Styling */
        .info-box {
          margin-bottom: 10px;
        }
        
        .info-box-content {
          padding: 10px 15px;
        }
        
        .info-box-text {
          font-size: 12px !important;
          font-weight: 600;
          text-transform: uppercase;
          letter-spacing: 0.5px;
        }
        
        .info-box-number {
          font-size: 18px !important;
          font-weight: bold;
          margin: 5px 0;
        }
        
        .info-box .progress {
          height: 3px !important;
          margin: 5px 0;
          background-color: rgba(0,0,0,0.1);
        }
        
        .progress-description {
          font-size: 11px !important;
          margin-top: 5px;
        }
        
        /* Cache Table Styling */
        #cache-details-table {
          font-size: 12px;
        }
        
        #cache-details-table th {
          background-color: #f8f9fa;
          font-weight: 600;
          font-size: 11px;
          text-transform: uppercase;
          letter-spacing: 0.5px;
        }
        
        #cache-details-table td {
          vertical-align: middle;
          padding: 8px 12px;
        }
        
        .badge {
          font-size: 10px;
          padding: 3px 6px;
        }
        
        /* Button Styling */
        .btn-xs {
          padding: 2px 8px;
          font-size: 10px;
          line-height: 1.2;
        }
        
        /* Cache Status Container */
        #cache-status-container .alert {
          margin-bottom: 15px;
          padding: 10px 15px;
          transition: opacity 0.5s ease-in-out;
        }
        
        #cache-status-container .alert ul {
          margin: 5px 0;
          padding-left: 20px;
        }
        
        #cache-status-container .alert li {
          margin: 2px 0;
          font-size: 11px;
        }
        
        /* Auto-hide animations */
        .alert-dismissible .close {
          position: relative;
          top: -2px;
          right: -10px;
          color: inherit;
          opacity: 0.5;
        }
        
        .alert-dismissible .close:hover {
          opacity: 0.75;
        }
        
        /* Fade out animation */
        .alert.fade-out {
          opacity: 0;
          transition: opacity 0.5s ease-in-out;
        }
      </style>
      
      <!-- Demo Mode Styling for Site Settings -->
      <?php if(demo_app()){ ?>
      <style>
        .form-control:disabled {
          background-color: #f5f5f5 !important;
          cursor: not-allowed !important;
          opacity: 0.6 !important;
        }
        
        .btn:disabled {
          cursor: not-allowed !important;
          opacity: 0.6 !important;
        }
        
        .nav-tabs-custom {
          opacity: 0.8;
        }
        
        .nav-tabs-custom::before {
          content: "DEMO MODE - READ ONLY";
          position: absolute;
          top: -10px;
          right: 20px;
          background: #f39c12;
          color: white;
          padding: 5px 15px;
          border-radius: 15px;
          font-size: 11px;
          font-weight: bold;
          z-index: 1000;
        }
      </style>
      <?php } ?>
     
 
      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
   </body>
</html>
