$(document).ready(function() {
    // Create backup
    $('#create_backup_form').on('submit', function(e) {
        e.preventDefault();
        
        var backup_name = $('#backup_name').val();
        
        $.ajax({
            url: base_url + 'backup/create_backup',
            type: 'POST',
            data: {backup_name: backup_name},
            beforeSend: function() {
                $('#create_backup_form button').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Creating...');
            },
            success: function(response) {
                if(response == 'success') {
                    toastr.success('Backup created successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error('Failed to create backup: ' + response);
                }
            },
            error: function() {
                toastr.error('An error occurred while creating backup');
            },
            complete: function() {
                $('#create_backup_form button').prop('disabled', false).html('<i class="fa fa-download"></i> Create Backup');
            }
        });
    });
    
    // Download backup
    $('.download-backup').on('click', function() {
        var filename = $(this).data('filename');
        
        // Create a form to submit the download request
        var form = $('<form>', {
            'method': 'POST',
            'action': base_url + 'backup/download_backup'
        });
        
        form.append($('<input>', {
            'type': 'hidden',
            'name': 'filename',
            'value': filename
        }));
        
        $('body').append(form);
        form.submit();
        form.remove();
    });
    
    // Restore backup
    $('.restore-backup').on('click', function() {
        var filename = $(this).data('filename');
        $('#restore_filename').text(filename);
        $('#restore_modal').modal('show');
    });
    
    $('#confirm_restore').on('click', function() {
        var filename = $('#restore_filename').text();
        
        $.ajax({
            url: base_url + 'backup/restore_backup',
            type: 'POST',
            data: {filename: filename},
            beforeSend: function() {
                $('#confirm_restore').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Restoring...');
            },
            success: function(response) {
                if(response == 'success') {
                    toastr.success('Database restored successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error('Failed to restore database: ' + response);
                }
            },
            error: function() {
                toastr.error('An error occurred while restoring database');
            },
            complete: function() {
                $('#confirm_restore').prop('disabled', false).html('Yes, Restore Database');
                $('#restore_modal').modal('hide');
            }
        });
    });
    
    // Delete backup
    $('.delete-backup').on('click', function() {
        var filename = $(this).data('filename');
        $('#delete_filename').text(filename);
        $('#delete_modal').modal('show');
    });
    
    $('#confirm_delete').on('click', function() {
        var filename = $('#delete_filename').text();
        
        $.ajax({
            url: base_url + 'backup/delete_backup',
            type: 'POST',
            data: {filename: filename},
            beforeSend: function() {
                $('#confirm_delete').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Deleting...');
            },
            success: function(response) {
                if(response == 'success') {
                    toastr.success('Backup deleted successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    toastr.error('Failed to delete backup: ' + response);
                }
            },
            error: function() {
                toastr.error('An error occurred while deleting backup');
            },
            complete: function() {
                $('#confirm_delete').prop('disabled', false).html('Yes, Delete Backup');
                $('#delete_modal').modal('hide');
            }
        });
    });
});

function format_bytes(bytes, precision = 2) {
    const units = ['B', 'KB', 'MB', 'GB', 'TB'];
    
    for (let i = 0; bytes > 1024 && i < units.length - 1; i++) {
        bytes /= 1024;
    }
    
    return Math.round(bytes * Math.pow(10, precision)) / Math.pow(10, precision) + ' ' + units[i];
} 