$("#view,#view_all").on("click",function(){
	
	 var base_url=$("#base_url").val();
    var from_date=document.getElementById("from_date").value;
    var to_date=document.getElementById("to_date").value;
    var category_id=document.getElementById("category_id").value;
  
	if(from_date == "")
      {
          toastr["warning"]("Select From Date!");
          document.getElementById("from_date").focus();
          return;
      }
	 
	 if(to_date == "")
      {
          toastr["warning"]("Select To Date!");
          document.getElementById("to_date").focus();
          return;
      }
	  
	   if(this.id=="view_all"){
          var view_all='yes';
        }
        else{
          var view_all='no';
        }
	  
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $.post(base_url+"reports/show_expense_report",{category_id:category_id,view_all:view_all,from_date:from_date,to_date:to_date,store_id:$("#store_id").val()},function(result){
          //alert(result);
            setTimeout(function() {
             $("#tbodyid").empty().append(result);     
             $(".overlay").remove();
             $("#print_a4").show();
             console.log("Print A4 button should be visible now");
            }, 0);
           }).fail(function() {
             // Show button even if request fails
             $(".overlay").remove();
             $("#print_a4").show();
             console.log("Request failed, but showing print button anyway");
           }); 
      
	
});

// Print A4 functionality
$("#print_a4").on("click",function(){
    console.log("Print A4 button clicked");
    printExpenseReport();
});

// Test button functionality
$("#print_a4_test").on("click",function(){
    console.log("Print A4 Test button clicked");
    printExpenseReport();
});

function printExpenseReport() {
    var from_date = document.getElementById("from_date").value;
    var to_date = document.getElementById("to_date").value;
    var category_id = document.getElementById("category_id").value;
    var store_id = $("#store_id").val();
    
    // Get current date and time
    var currentDate = new Date();
    var dateTime = currentDate.toLocaleDateString() + ' ' + currentDate.toLocaleTimeString();
    
    // Get category name if selected
    var categoryName = "";
    if(category_id) {
        var selectedOption = $("#category_id option:selected").text();
        categoryName = selectedOption !== "-All-" ? selectedOption : "";
    }
    
    // Create print window
    var printWindow = window.open('', '_blank');
    printWindow.document.write(`
        <!DOCTYPE html>
        <html>
        <head>
            <title>Expense Report - A4 Print</title>
            <style>
                @page {
                    size: A4;
                    margin: 0.5in;
                }
                body {
                    font-family: Arial, sans-serif;
                    font-size: 12px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 10px;
                }
                .print-header {
                    text-align: center;
                    margin-bottom: 20px;
                    border-bottom: 2px solid #333;
                    padding-bottom: 10px;
                }
                .company-name {
                    font-size: 18px;
                    font-weight: bold;
                    margin-bottom: 5px;
                }
                .report-title {
                    font-size: 16px;
                    font-weight: bold;
                    margin-bottom: 5px;
                }
                .report-period {
                    font-size: 14px;
                    color: #666;
                }
                .print-date {
                    font-size: 10px;
                    color: #999;
                    margin-top: 5px;
                }
                table {
                    width: 100%;
                    border-collapse: collapse;
                    margin-top: 10px;
                }
                th, td {
                    border: 1px solid #333;
                    padding: 6px;
                    text-align: left;
                    font-size: 11px;
                }
                th {
                    background-color: #f5f5f5;
                    font-weight: bold;
                }
                .text-right {
                    text-align: right;
                }
                .text-center {
                    text-align: center;
                }
                .total-row {
                    font-weight: bold;
                    background-color: #f9f9f9;
                }
                .no-print {
                    display: none;
                }
            </style>
        </head>
        <body>
            <div class="print-header">
                <div class="company-name">${getStoreName(store_id)}</div>
                <div class="report-title">Expense Report</div>
                <div class="report-period">From: ${from_date} To: ${to_date}${categoryName ? ' | Category: ' + categoryName : ''}</div>
                <div class="print-date">Generated on: ${dateTime}</div>
            </div>
            <div id="print-content">
                ${document.getElementById('report-data').outerHTML}
            </div>
        </body>
        </html>
    `);
    
    printWindow.document.close();
    printWindow.focus();
    setTimeout(function() {
        printWindow.print();
        printWindow.close();
    }, 500);
}

function getStoreName(storeId) {
    // This would typically make an AJAX call to get store name
    // For now, return a placeholder
    return "NCS BILLING BOOK";
}

