
//On Enter Move the cursor to desigtation Id
function shift_cursor(kevent,target){

    if(kevent.keyCode==13){
		$("#"+target).focus();
    }
	
}


$('#save,#update').on("click",function (e) {
  
	var base_url=$("#base_url").val();
  var this_id=this.id;
    //Initially flag set true
    var flag=true;

    // Check exchange rate validation before proceeding
    var customer_id = $("#customer_id").val();
    if (customer_id) {
        // Check exchange rate synchronously
        var exchangeRateValid = true;
        $.ajax({
            url: base_url + 'exchange_rates/validate_customer_exchange_rate',
            type: 'POST',
            data: { 
                customer_id: customer_id
            },
            dataType: 'json',
            async: false, // Make it synchronous
            success: function(response) {
                if (!response.valid) {
                    exchangeRateValid = false;
                    // Show persistent modal instead of toast
                    showExchangeRateModal(response.message, response.from_currency, response.to_currency, base_url);
                } else {
                }
            },
            error: function() {
                exchangeRateValid = false;
                toastr.error('Error checking exchange rate. Please try again.');
            }
        });
        
        if (!exchangeRateValid) {
            return false;
        }
    }

    function check_field(id)
    {

      if(!$("#"+id).val() ) //Also check Others????
        {

            $('#'+id+'_msg').fadeIn(200).show().html('Required Field').addClass('required');
           // $('#'+id).css({'background-color' : '#E8E2E9'});
            flag=false;
        }
        else
        {
             $('#'+id+'_msg').fadeOut(200).hide();
             //$('#'+id).css({'background-color' : '#FFFFFF'});    //White color
        }
    }


   //Validate Input box or selection box should not be blank or empty
	  check_field("customer_id");
    check_field("sales_date");
    check_field("sales_status");
    check_field("count_id");
    //check_field("warehouse_id");
	/*if(!isNaN($("#amount").val()) && parseInt($("#amount").val())==0){
        toastr["error"]("You have entered Payment Amount! <br>Please Select Payment Type!");
        return;
    }*/
    
    
	if(flag==false)
	{
		toastr["error"]("You have missed Something to Fillup!");
		return;
	}

	//Atleast one record must be added in sales table 
    var rowcount=document.getElementById("hidden_rowcount").value;
	var flag1=false;
	for(var n=1;n<=rowcount;n++){
		if($("#td_data_"+n+"_3").val()!=null && $("#td_data_"+n+"_3").val()!=''){
			flag1=true;
		}	
	}
	
    if(flag1==false){
    	toastr["warning"]("Please Select Item!!");
        $("#item_search").focus();
		return;
    }
    //end


    if(this_id=='save' && $('option:selected', "#customer_id").attr('data-delete_bit')==1){
      if(parseFloat($("#total_amt").text())!=parseFloat($("#amount").val())){
        $("#amount").focus();
        toastr["warning"]("Walk-in Customer Should Pay Complete Amount!!");
        return;
      }

     
        if($("#payment_type").val()==''){
          toastr["warning"]("Please Select Payment Type!!");
          return;
        }
     


    }
    if(this_id=='save'){
      if($("#amount").val()!=''){
          if($("#payment_type").val()==''){
            toastr["warning"]("Please Select Payment Type!!");
            return;
          }
      }
  }

    var tot_subtotal_amt=$("#subtotal_amt").text();
    var other_charges_amt=$("#other_charges_amt").text();//other_charges include tax calcualated amount
    var tot_discount_to_all_amt=$("#discount_to_all_amt").text();
    var tot_round_off_amt=$("#round_off_amt").text();
    var tot_total_amt=$("#total_amt").text();
    var coupon_discount_amt=$("#coupon_discount_amt").text();

    
    
			//if(confirm("Do You Wants to Save Record ?")){
				e.preventDefault();
				data = new FormData($('#sales-form')[0]);//form name
        /*Check XSS Code*/
        if(!xss_validation(data)){ return false; }
        
        $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
        $("#"+this_id).attr('disabled',true);  //Enable Save or Update button
				$.ajax({
				type: 'POST',
				url: base_url+'sales/sales_save_and_update?command='+this_id+'&rowcount='+rowcount+'&tot_subtotal_amt='+tot_subtotal_amt+'&tot_discount_to_all_amt='+tot_discount_to_all_amt+'&tot_round_off_amt='+tot_round_off_amt+'&tot_total_amt='+tot_total_amt+"&other_charges_amt="+other_charges_amt+"&coupon_discount_amt="+coupon_discount_amt,
				data: data,
				cache: false,
				contentType: false,
				processData: false,
				timeout: 30000, // 30 second timeout
				success: function(result){
         // alert(result);return;
				result=result.split("<<<###>>>");
					if(result[0]=="success")
					{
						location.href=base_url+"sales/invoice/"+result[1];
					}
					else if(result[0]=="failed")
					{
					   toastr['error']("Sorry! Failed to save Record.Try again");
					}
					else if(result[0].startsWith("insufficient_stock:"))
					{
						// Extract the message after "insufficient_stock:"
						var message = result[0].substring("insufficient_stock:".length);
						toastr['warning'](message);
					}
					else
					{
						toastr['error'](result[0]);
					}
					$("#"+this_id).attr('disabled',false);  //Enable Save or Update button
					$(".overlay").remove();

			   },
			   error: function(xhr, status, error) {
				   $("#"+this_id).attr('disabled',false);  //Enable Save or Update button
				   $(".overlay").remove();
				   
				   // Handle timeout/error errors
				   if (status === 'timeout' || status === 'error') {
						   toastr["error"]("Request timed out. Please try again.");
				   } else {
					   toastr["error"]("An error occurred while saving. Please try again.");
				   }
			   }
			   });
		//}
  
});


$("#item_search").bind("paste", function(e){
    $("#item_search").autocomplete('search');
} );

$("#item_search").autocomplete({
    source: function(data, cb){
        $.ajax({
        	autoFocus:true,
            url: $("#base_url").val()+'items/get_json_items_details',
            method: 'GET',
            dataType: 'json',
            /*showHintOnFocus: true,
			autoSelect: true, 
			
			selectInitial :true,*/
			
            data: {
                name: data.term,
                store_id:$("#store_id").val(),
                warehouse_id:$("#warehouse_id").val(),
                search_for:"sales",
            },
            beforeSend: function() {
                if($("#warehouse_id").val()==''){
                  toastr['warning']("Please Select Wareshouse!");
                  $("#warehouse_id").select2('open');
                  $("#item_search").removeClass('ui-autocomplete-loading');
                  return;
                }
                $("#item_search").addClass('ui-autocomplete-loading');
            },
            success: function(res){
              //console.log(res);
                var result;
                result = [
                    {
                        //label: 'No Records Found '+data.term,
                        label: 'No Records Found ',
                        value: ''
                    }
                ];

                if (res.length) {
                    result = $.map(res, function(el){
                      qty_ = (el.service_bit!=1) ? '--[Qty:'+el.stock+'] --' : '--';
                      pur_price = (el.purchase_price!='') ? '[Pur.Price:'+el.purchase_price+'] --' : '';


                        return {
                            label: el.item_code +qty_+ pur_price + el.label,
                            value: '',
                            id: el.id,
                            item_name: el.value,
                            stock: el.stock,
                            service_bit: el.service_bit,
                           // mobile: el.mobile,
                            //customer_dob: el.customer_dob,
                            //address: el.address,
                        };
                    });
                }

                cb(result);
            }
        });
    },
     response:function(e,ui){
          if(ui.content.length==1){
            $(this).data('ui-autocomplete')._trigger('select', 'autocompleteselect', ui);
            $(this).autocomplete("close");
          }
          //console.log(ui.content[0].id);
        },
        //loader start
        search: function (e, ui) {
        },
        select: function (e, ui) { 
          	 /*if(u.item.value==''){
               $("#item_search").removeClass('ui-autocomplete-loader-center');
             }
          
            if(parseInt(u.item.stock)<=0){
              toastr["warning"](u.item.stock+" Items in Stock!!");
              failed.currentTime = 0; 
              failed.play();
              return false;
            }
            var item_id =u.item.id;
            if(restrict_quantity(item_id)){
              return_row_with_data(item_id);  
            }*/
            
           
            if(typeof ui.content!='undefined'){
              if(isNaN(ui.content[0].id)){
                return;
              }
              var stock=ui.content[0].stock;
              var item_id=ui.content[0].id;
              var service_bit=ui.content[0].service_bit;
            }
            else{
              var stock=ui.item.stock;
              var item_id=ui.item.id;
              var service_bit=ui.item.service_bit;
            }
            if(service_bit==0 && parseFloat(stock)<=0){
              toastr["warning"](stock+" Items in Stock!!");
              failed.currentTime = 0; 
              failed.play();
              return false;
            }


            if(service_bit==1){
              return_row_with_data(item_id);  
            }
            else {
              if(restrict_quantity(item_id)){
                return_row_with_data(item_id);  
              }
            }
            $("#item_search").val('');
            
            
        },   
        //loader end
});


function check_same_item(item_id){
  if($("#sales_table tr").length>1){
    var rowcount=$("#hidden_rowcount").val();
    for(i=0;i<=rowcount;i++){
            if($("#tr_item_id_"+i).val()==item_id){
              increment_qty(i);
              failed.currentTime = 0;
              failed.play();
              return false;
            }
      }//end for
  }
  return true;
}

function return_row_with_data(item_id){
  //CHECK SAME ITEM ALREADY EXIST IN ITEMS TABLE 
  var item_check=check_same_item(item_id);
  if(!item_check){return false;}
  //END

  $("#item_search").addClass('ui-autocomplete-loader-center');
  var base_url=$("#base_url").val();
  var rowcount=$("#hidden_rowcount").val();
  var warehouse_id=$("#warehouse_id").val();
  var customer_id=$("#customer_id").val();
  
  $.post(base_url+"sales/return_row_with_data/"+rowcount+"/"+item_id,{customer_id:customer_id,warehouse_id:warehouse_id},function(result){
        //alert(result);
        $('#sales_table tbody').append(result);
        $("#hidden_rowcount").val(parseInt(rowcount)+1);
        success.currentTime = 0;
        success.play();
        enable_or_disable_item_discount();
        $("#item_search").removeClass('ui-autocomplete-loader-center');
        $("#item_search").removeClass('ui-autocomplete-loading');
    }); 
}

// Function to refresh existing items with customer-specific pricing for Sales
function refresh_existing_items_with_customer_pricing_sales(){
  var customer_id = $("#customer_id").val();
  var warehouse_id = $("#warehouse_id").val();
  var base_url = $("#base_url").val();
  
  // Only proceed if customer is selected and not walk-in
  if (!customer_id || customer_id === '' || customer_id === '1') {
    return;
  }
  
  // Get all existing items in the table
  var existingItems = [];
  $("#sales_table tbody tr").each(function() {
    var itemId = $(this).find('input[id^="tr_item_id_"]').val();
    var qty = $(this).find('input[id^="td_data_"][id$="_3"]').val();
    
    if (itemId && qty) {
      existingItems.push({
        item_id: itemId,
        qty: qty,
        row: $(this)
      });
    }
  });
  
  if (existingItems.length === 0) {
    return;
  }
  
  // Show loading indicator
  $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
  
  // Process each item
  var processedCount = 0;
  var totalItems = existingItems.length;
  
  existingItems.forEach(function(item) {
    $.post(base_url + "sales/find_item_details", {
      id: item.item_id,
      customer_id: customer_id
    }, function(result) {
      try {
        var itemData = jQuery.parseJSON(result);
        
        // Update the price in the existing row
        var priceInput = item.row.find('input[id^="td_data_"][id$="_10"]');
        var priceHiddenInput = item.row.find('input[id^="td_data_"][id$="_4"]');
        
        if (priceInput.length && priceHiddenInput.length) {
          var newPrice = parseFloat(itemData.sales_price);
          var formattedPrice = newPrice.toFixed(2);
          
          // Update the displayed price
          priceInput.val(formattedPrice);
          priceHiddenInput.val(newPrice);
          
          
          // Recalculate totals for this row
          var rowIndex = item.row.attr('data-row');
          if (rowIndex) {
            calculate_tax(rowIndex);
          }
        }
        
        processedCount++;
        
        // If all items processed, remove loading and recalculate totals
        if (processedCount === totalItems) {
          $(".overlay").remove();
          final_total();
        }
      } catch (e) {
        processedCount++;
        
        if (processedCount === totalItems) {
          $(".overlay").remove();
          final_total();
        }
      }
    }).fail(function() {
      processedCount++;
      
      if (processedCount === totalItems) {
        $(".overlay").remove();
        final_total();
      }
    });
  });
}
//INCREMENT ITEM
function increment_qty(rowcount){
  var service_bit =$("#service_bit_"+rowcount).val();
  var flag = restrict_quantity($("#tr_item_id_"+rowcount).val(),service_bit);
  if(!flag){ return false;}

  var item_qty=$("#td_data_"+rowcount+"_3").val();
  var available_qty=$("#tr_available_qty_"+rowcount+"_13").val();
  if(service_bit==1 || parseFloat(item_qty)<parseFloat(available_qty)){
    item_qty=parseFloat(item_qty)+1;
    $("#td_data_"+rowcount+"_3").val(format_qty(item_qty));
  }
  calculate_tax(rowcount);
  check_stock_availability(rowcount);
}
//DECREMENT ITEM
function decrement_qty(rowcount){
  var service_bit =$("#service_bit_"+rowcount).val();
  var item_qty=parseFloat($("#td_data_"+rowcount+"_3").val());
  if(service_bit==1 || item_qty<=1){
    $("#td_data_"+rowcount+"_3").val(format_qty(1));
    return;
  }
  $("#td_data_"+rowcount+"_3").val(format_qty(item_qty-1));
  calculate_tax(rowcount);
  check_stock_availability(rowcount);
}

//CHECK STOCK AVAILABILITY
function check_stock_availability(rowcount){
  var item_id = $("#tr_item_id_"+rowcount).val();
  var service_bit = $("#service_bit_"+rowcount).val();
  var sales_qty = parseFloat($("#td_data_"+rowcount+"_3").val());
  var available_qty = parseFloat($("#tr_available_qty_"+rowcount+"_13").val());
  var item_name = $("#td_data_"+rowcount+"_1").text().trim();
  
  // Skip check for services
  if(service_bit == 1){
    return;
  }
  
  // Check if quantity exceeds available stock
  if(sales_qty > available_qty){
    var message = item_name + " has only " + available_qty + " in Stock!!";
    toastr['warning'](message);
    
    // Optionally, reset to available quantity
    $("#td_data_"+rowcount+"_3").val(format_qty(available_qty));
    calculate_tax(rowcount);
  }
}

function update_paid_payment_total() {
  var rowcount=$("#paid_amt_tot").attr("data-rowcount");
  var tot=0;
  for(i=1;i<rowcount;i++){
    if(document.getElementById("paid_amt_"+i)){
      tot += parseFloat($("#paid_amt_"+i).html());
    }
  }
  $("#paid_amt_tot").html(to_Fixed(tot));
}
function delete_payment(payment_id){
 if(confirm("Do You Wants to Delete Record ?")){
    var base_url=$("#base_url").val();
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
   $.post(base_url+"sales/delete_payment",{payment_id:payment_id},function(result){
   //alert(result);return;
   result=result;
     if(result=="success")
        { 
          toastr["success"]("Record Deleted Successfully!");
          $("#payment_row_"+payment_id).remove();
          success.currentTime = 0; 
          success.play();
        }
        else if(result=="failed"){
          toastr["error"]("Failed to Delete .Try again!");
          failed.currentTime = 0; 
          failed.play();
        }
        else{
          toastr["error"](result);
          failed.currentTime = 0; 
          failed.play();
        }
        $(".overlay").remove();
        update_paid_payment_total();
        restore_customer_list();
   });
   }//end confirmation   
  }

function restore_customer_list(){
   var base_url=$("#base_url").val();
   var customer_id = $("#customer_id").val();
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url+"customers/restore_customer_list",{customer_id,customer_id},function(result){
        $("#customer_id").select2().empty();
        $("#customer_id").html(result).select2();
        $("#customer_id").trigger('change');
        
        $(".overlay").remove();
        return false;
   });
}

  //Delete Record start
function delete_sales(q_id)
{
  var base_url=$("#base_url").val();
   if(confirm("Do You Wants to Delete Record ?")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url+"sales/delete_sales",{q_id:q_id},function(result){
   //alert(result);return;
     if(result=="success")
        {
          toastr["success"]("Record Deleted Successfully!");
          $('#example2').DataTable().ajax.reload();
        }
        else if(result=="failed"){
          toastr["error"]("Failed to Delete .Try again!");
        }
        else if(result.startsWith("conflict:")){
          // Handle account conflict
          var conflictData = JSON.parse(result.substring(9));
          var conflictMessage = "Cannot delete this transaction. It has affected the following accounts:\n\n";
          conflictData.forEach(function(conflict) {
            conflictMessage += "• " + conflict.account_name + " - Amount: " + conflict.amount + " (Date: " + conflict.date + ")\n";
          });
          conflictMessage += "\nPlease check account balances before deleting.";
          toastr["warning"](conflictMessage);
        }
        else{
           toastr["error"](result);
        }
        $(".overlay").remove();
        return false;
   });
   }//end confirmation
}
//Delete Record end
function multi_delete(){
  var base_url=$("#base_url").val();
    var this_id=this.id;
    
    if(confirm("Are you sure ?")){
      data = new FormData($('#table_form')[0]);//form name
      /*Check XSS Code*/
      if(!xss_validation(data)){ return false; }
      
      $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
      $("#"+this_id).attr('disabled',true);  //Enable Save or Update button
      $.ajax({
      type: 'POST',
      url: base_url+'sales/multi_delete',
      data: data,
      cache: false,
      contentType: false,
      processData: false,
      success: function(result){
        result=result;
  //alert(result);return;
        if(result=="success")
        {
          toastr["success"]("Record Deleted Successfully!");
          success.currentTime = 0; 
            success.play();
          $('#example2').DataTable().ajax.reload();
          $(".delete_btn").hide();
          $(".group_check").prop("checked",false).iCheck('update');
        }
        else if(result=="failed")
        {
           toastr["error"]("Sorry! Failed to save Record.Try again!");
           failed.currentTime = 0; 
           failed.play();
        }
        else
        {
          toastr["error"](result);
          failed.currentTime = 0; 
            failed.play();
        }
        $("#"+this_id).attr('disabled',false);  //Enable Save or Update button
        $(".overlay").remove();
       }
       });
  }
  //e.preventDefault
}

function pay_now(sales_id){
  var base_url=$("#base_url").val();
  $.post(base_url+'sales/show_pay_now_modal', {sales_id: sales_id}, function(result) {
    $(".pay_now_modal").html('').html(result);
    //Date picker
    $('.datepicker').datepicker({
      autoclose: true,
    format: 'dd-mm-yyyy',
     todayHighlight: true
    });
    $('#pay_now').modal('toggle');

  });
}
function view_payments(sales_id){
  var base_url=$("#base_url").val();
  $.post(base_url+'sales/view_payments_modal', {sales_id: sales_id}, function(result) {
    $(".view_payments_modal").html('').html(result);
    $('#view_payments_modal').modal('toggle');
  });
}

function save_payment(sales_id){
  var base_url=$("#base_url").val();

    //Initially flag set true
    var flag=true;

    function check_field(id)
    {

      if(!$("#"+id).val() ) //Also check Others????
        {

            $('#'+id+'_msg').fadeIn(200).show().html('Required Field').addClass('required');
           // $('#'+id).css({'background-color' : '#E8E2E9'});
            flag=false;
        }
        else
        {
             $('#'+id+'_msg').fadeOut(200).hide();
             //$('#'+id).css({'background-color' : '#FFFFFF'});    //White color
        }
    }


   //Validate Input box or selection box should not be blank or empty
    check_field("amount");
    check_field("payment_date");
    check_field("payment_currency");


    var payment_date=$("#payment_date").val();
    var amount=$("#amount").val();
    var payment_type=$("#payment_type").val();
    var payment_note=$("#payment_note").val();
    var account_id=$("#account_id").val();
    var customer_id=$("#customer_id").val();
    var payment_currency=$("#payment_currency").val();
    var cheque_number=$("#cheque_number").val();
    var cheque_period=$("#cheque_period").val();

    if(amount == 0){
      toastr["error"]("Please Enter Valid Amount!");
      return false; 
    }

    if(amount > parseFloat($("#due_amount_temp").html())){
      toastr["error"]("Entered Amount Should not be Greater than Due Amount!");
      return false;
    }

    // Validate account currency matches payment currency
    if(account_id && payment_currency) {
      var accountCurrencyValid = false;
      $.ajax({
        url: base_url + 'sales/get_account_currency',
        type: 'POST',
        data: { account_id: account_id },
        dataType: 'json',
        async: false, // Make synchronous for validation
        success: function(response) {
          if (response.success && response.currency_id) {
            if (response.currency_id != payment_currency) {
              toastr["error"]("Currency mismatch: Selected account currency (" + response.currency_code + ") doesn't match payment currency. Please select an account with the same currency as the payment.");
              accountCurrencyValid = false;
            } else {
              accountCurrencyValid = true;
            }
          } else {
            accountCurrencyValid = true; // Allow if no currency info
          }
        },
        error: function() {
          accountCurrencyValid = true; // Allow if error
        }
      });
      
      if (!accountCurrencyValid) {
        return false;
      }
    }

    //verify advance is checked or not
    allow_tot_advance = 'checked';
    if(!$("#allow_tot_advance").prop("checked")){
      allow_tot_advance='';
    }

    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $(".payment_save").attr('disabled',true);  //Enable Save or Update button
    $.post(base_url+'sales/save_payment', {cheque_number:cheque_number,cheque_period:cheque_period,allow_tot_advance:allow_tot_advance,customer_id:customer_id,account_id:account_id,sales_id: sales_id,payment_type:payment_type,amount:amount,payment_date:payment_date,payment_note:payment_note,payment_currency:payment_currency}, function(result) {
      result=result;
  //alert(result);return;
        if(result=="success")
        {
          $('#pay_now').modal('toggle');
          toastr["success"]("Payment Recorded Successfully!");
          success.currentTime = 0; 
          success.play();
          $('#example2').DataTable().ajax.reload();
        }
        else if(result=="failed")
        {
           toastr["error"]("Sorry! Failed to save Record.Try again!");
           failed.currentTime = 0; 
           failed.play();
        }
        else
        {
          toastr["error"](result);
          failed.currentTime = 0; 
          failed.play();
        }
        $(".payment_save").attr('disabled',false);  //Enable Save or Update button
        $(".overlay").remove();
    });
}

function delete_sales_payment(payment_id){
 if(confirm("Do You Wants to Delete Record ?")){
    var base_url=$("#base_url").val();
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
   $.post(base_url+"sales/delete_payment",{payment_id:payment_id},function(result){
   //alert(result);return;
   result=result;
     if(result=="success")
        {
          $('#view_payments_modal').modal('toggle');
          toastr["success"]("Record Deleted Successfully!");
          success.currentTime = 0; 
          success.play();
          $('#example2').DataTable().ajax.reload();
        }
        else if(result=="failed"){
          toastr["error"]("Failed to Delete .Try again!");
          failed.currentTime = 0; 
          failed.play();
        }
        else{
          toastr["error"](result);
          failed.currentTime = 0; 
          failed.play();
        }
        $(".overlay").remove();
   });
   }//end confirmation   
  }

  function restrict_quantity(item_id,service_bit=0) {
  	var rowcount=$("#hidden_rowcount").val();
  	var available_qty = 0;
  	var count_item_qty = 0;
  	var selected_item_id = 0;
      for(i=1;i<=rowcount;i++){
        if(document.getElementById("tr_item_id_"+i)){
        	selected_item_id = $("#tr_item_id_"+i).val();
            if(parseInt(item_id)==parseInt(selected_item_id)){
	             available_qty = parseFloat($("#tr_available_qty_"+i+"_13").val());
	             count_item_qty += parseFloat($("#td_data_"+i+"_3").val());
          }

        }
      }//end for
      if( service_bit==0 && available_qty!=0 && count_item_qty>=available_qty){
        toastr["warning"]("Only "+available_qty+" Items in Stock!!");
        failed.currentTime = 0; 
        failed.play();
      	return false;
      }
      return true;
  }

  /*$("#warehouse_id").on("change",function(event) {
    $('#sales_table tbody').html('');
    final_total();
    if($("#warehouse_id").val()!=''){
      $("#item_search").attr({ disabled: false,});
    }
    else{
     $("#item_search").attr({ disabled: true,}); 
    }
  });*/

function get_coupon_details(){
  var input_box = $("#coupon_code");
  var coupon_code = $.trim(input_box.val());
  var customer_id = $("#customer_id").val();
  var base_url=$("#base_url").val();

  var coupon_type='';
  var coupon_value=0;
  if(coupon_code!=''){
    input_box.addClass('ui-autocomplete-loading');
    $.post(base_url+'customer_coupon/get_coupon_details', {invoice_type:'sales',coupon_code: coupon_code,customer_id:customer_id}, function(data, textStatus, xhr) {
      var json = $.parseJSON(data);
      coupon_value=json.coupon_value;
      coupon_type=json.coupon_type;

      $(".coupon_value").html(to_Fixed(coupon_value));
      $(".coupon_type").html(coupon_type);  

      $(".div1").removeClass('hide');
      
      if(json.expire_status=='Valid'){
        $(".msg_color").removeClass('alert-warning').addClass('alert-success');
      }
      else{
       $(".msg_color").removeClass('alert-success').addClass('alert-warning'); 
      }
      $("#coupon_code_msg").text(json.message);

      input_box.removeClass('ui-autocomplete-loading');

      final_total();
    });
  }else{
    $(".div1").addClass('hide');
    $(".coupon_value").html(to_Fixed(coupon_value));
    $(".coupon_type").html(coupon_type);  
    final_total();
  }  
}


$("#coupon_code, #customer_id").on("change",function() {
  get_coupon_details();
  show_customer_currency();
  update_payment_currency_dropdown();
  
  // If customer changed, refresh existing items with customer-specific pricing
  if (this.id === 'customer_id') {
    setTimeout(function() {
      refresh_existing_items_with_customer_pricing_sales();
    }, 100);
  }
});
$('#coupon_code').keypress(function (e) {
 var key = e.which;
 // the enter key code
 if(key == 13){
    get_coupon_details();  
  }
});

// Show customer currency information
function show_customer_currency() {
  var customer_id = $("#customer_id").val();
  var base_url = $("#base_url").val();
  
  // Hide both currency displays first
  $("#customer_currency_info").hide();
  $("#walkin_currency_info").hide();
  
  if (customer_id) {
    // Check if it's a walk-in customer
    var customerText = $("#customer_id option:selected").text();
    if (customer_id === '1' || customerText.toLowerCase().includes('walk-in')) {
      // Show walk-in currency display
      var baseCurrency = window.baseCurrencyName || 'Base Currency';
      var baseCode = window.baseCurrencyCode || 'USD';
      var baseSymbol = window.baseCurrencySymbol || '$';
      
      $("#walkin_currency_name").text(baseCurrency + " (" + baseCode + ")");
      $("#walkin_currency_info").show();
      
      // Update currency symbols
      $("#discount_currency_symbol").text(baseSymbol);
      update_summary_currency_symbols(baseSymbol);
      
      // Load accounts for walk-in customer (base currency)
      if (typeof window.loadAccountsForCustomerCurrency === 'function') {
        window.loadAccountsForCustomerCurrency();
      }
      return;
    }
    
    $.ajax({
      url: base_url + 'sales/check_currency_availability',
      type: 'POST',
      data: { customer_id: customer_id },
      dataType: 'json',
      success: function(response) {
        if (response.success) {
          // Get customer currency details
          $.ajax({
            url: base_url + 'customers/get_customer_currency',
            type: 'POST',
            data: { customer_id: customer_id },
            dataType: 'json',
            success: function(currency_response) {
              if (currency_response.currency_name) {
                $("#customer_currency_name").text(currency_response.currency_name + ' (' + currency_response.currency_code + ')');
                $("#customer_currency_info").show();
                
                // Change currency symbols in table headers
                var symbol = currency_response.currency_symbol || currency_response.currency_code || '$';
                $("#discount_currency_symbol").text(symbol);
                update_summary_currency_symbols(symbol);
              } else {
                $("#customer_currency_info").hide();
                // Reset to base currency symbol
                $("#discount_currency_symbol").text('$');
                update_summary_currency_symbols('$');
              }
            }
          });
        } else {
          // Show error message
          $("#customer_currency_name").text('Error: ' + response.message);
          $("#customer_currency_info").show().removeClass('label-info').addClass('label-danger');
        }
      },
      error: function() {
        $("#customer_currency_info").hide();
      }
    });
  } else {
    $("#customer_currency_info").hide();
    // Reset to base currency symbol
    $("#discount_currency_symbol").text('$');
    update_summary_currency_symbols('$');
  }
}

// Function to update all summary currency symbols
function update_summary_currency_symbols(symbol) {
  $(".currency_symbol").each(function() {
    $(this).text(symbol);
  });
}

$('#item_search').keypress(function (e) {
 var key = e.which;
 // the enter key code
 if(key == 13){
    $("#item_search").autocomplete('search');
  }
});

// Function to update payment currency dropdown when customer changes
function update_payment_currency_sales() {
  var selected_currency = $('#payment_currency').val();
  // This function can be expanded to handle currency conversion logic
}

// Function to update payment currency dropdown options when customer is selected
function update_payment_currency_dropdown() {
  var customer_id = $('#customer_id').val();
  
  if (customer_id && customer_id !== '') {
    // Make AJAX call to get customer currency
    $.ajax({
      url: base_url + 'customers/get_customer_currency',
      type: 'POST',
      data: { customer_id: customer_id },
      dataType: 'json',
      success: function(currency_response) {
        if (currency_response.status) {
          // Update payment currency dropdown
          var base_currency_id = currency_response.base_currency_id;
          var customer_currency_id = currency_response.customer_currency_id;
          
          // Clear existing options
          $('#payment_currency').empty();
          
          // Add customer currency option first (as default) if different from base
          if (customer_currency_id && customer_currency_id != base_currency_id) {
            $('#payment_currency').append('<option value="' + customer_currency_id + '" selected>' + currency_response.customer_currency_name + ' (' + currency_response.customer_currency_code + ') - Customer Currency</option>');
            // Add base currency option as secondary
            $('#payment_currency').append('<option value="' + base_currency_id + '">' + currency_response.base_currency_name + ' (' + currency_response.base_currency_code + ') - Base Currency</option>');
          } else {
            // Customer uses base currency, so base currency is selected
            $('#payment_currency').append('<option value="' + base_currency_id + '" selected>' + currency_response.base_currency_name + ' (' + currency_response.base_currency_code + ') - Base Currency</option>');
          }
          
          // Load accounts for the selected payment currency
          if (typeof window.loadAccountsForCustomerCurrency === 'function') {
            window.loadAccountsForCustomerCurrency();
          }
        }
      },
      error: function() {
      }
    });
  } else {
    // Reset to base currency only
    $.ajax({
      url: base_url + 'customers/get_base_currency',
      type: 'POST',
      dataType: 'json',
      success: function(currency_response) {
        if (currency_response.status) {
          $('#payment_currency').empty();
          $('#payment_currency').append('<option value="' + currency_response.currency_id + '" selected>' + currency_response.currency_name + ' (' + currency_response.currency_code + ') - Base Currency</option>');
        }
      }
    });
  }
}

// Currency validation functions for payment modal
function updatePaymentCurrency() {
    var selected_currency = $('#payment_currency').val();
    var base_currency_id = '<?= get_base_currency()->id; ?>';
    
    // Use enhanced payment currency function
    updatePaymentCurrencySales();
    
    // Update currency conversion display
    updateCurrencyConversion();
    
    // Check exchange rate
    checkPaymentCurrencyExchangeRateSales();
}

function validateAccountCurrency() {
    // Use enhanced validation function
    validateAccountCurrencySales();
    
    // Also check account balance
    checkAccountBalanceSales();
}

function setPaymentAccountForCurrency(currency_id) {
    
    $.ajax({
        url: base_url + 'sales/get_accounts_for_currency',
        type: 'POST',
        data: { currency_id: currency_id },
        dataType: 'json',
        success: function (res) {
            
            if (res.status && res.accounts.length > 0) {
                // Find the first cash account or just use the first account
                var selectedAccountId = null;
                
                // Look for cash accounts first
                for (var i = 0; i < res.accounts.length; i++) {
                    if (res.accounts[i].name.toLowerCase().includes('cash')) {
                        selectedAccountId = res.accounts[i].id;
                        break;
                    }
                }
                
                // If no cash account found, use the first account
                if (!selectedAccountId) {
                    selectedAccountId = res.accounts[0].id;
                }
                
                if (selectedAccountId) {
                    $("#account_id").val(selectedAccountId).trigger('change');
                }
            } else {
            }
        },
        error: function(xhr, status, error) {
        }
    });
}

// Enhanced Sales Payment Functions
var salesPaymentCurrencyLoading = false;
var salesAccountLoading = false;
var salesAccountCache = {}; // Cache for loaded accounts

function updatePaymentCurrencySales() {
  // Prevent multiple simultaneous calls
  if (salesPaymentCurrencyLoading) {
    return;
  }
  
  var selected_currency = $('#payment_currency').val();
  var base_currency_id = '<?= get_base_currency()->id; ?>';
  var customer_currency_id = null;

  if (!selected_currency) {
    $('#account_id').html('<option value="">-Select Currency First-</option>');
    return;
  }

  salesPaymentCurrencyLoading = true;

  // Get customer currency if available
  var customer_id = $('#customer_id').val();
  if (customer_id) {
    $.ajax({
      url: base_url + 'customers/get_customer_currency',
      type: 'POST',
      data: { customer_id: customer_id },
      dataType: 'json',
      success: function(response) {
        salesPaymentCurrencyLoading = false;
        if (response && response.status) {
          customer_currency_id = response.customer_currency_id;
          // Auto-select customer currency account if payment currency matches customer currency
          if (selected_currency == customer_currency_id) {
            autoSelectCurrencyAccountSales();
          } else {
            // Load accounts for selected currency
            loadAccountsForPaymentCurrencySales(selected_currency);
          }
        } else {
          loadAccountsForPaymentCurrencySales(selected_currency);
        }
      },
      error: function() {
        salesPaymentCurrencyLoading = false;
        loadAccountsForPaymentCurrencySales(selected_currency);
      }
    });
  } else {
    salesPaymentCurrencyLoading = false;
    loadAccountsForPaymentCurrencySales(selected_currency);
  }
}

function loadAccountsForPaymentCurrencySales(currency_id) {
  if (!currency_id) return;
  
  // Check if accounts are already cached for this currency
  if (salesAccountCache[currency_id]) {
    displayCachedSalesAccounts(currency_id);
    return;
  }
  
  // Prevent multiple simultaneous calls
  if (salesAccountLoading) {
    return;
  }
  
  salesAccountLoading = true;
  
  // Show loading state
  $('#account_id').html('<option value="">Loading accounts...</option>');
  
  $.ajax({
    url: base_url + 'sales/get_accounts_by_currency',
    type: 'POST',
    data: { 
      currency_id: currency_id,
      customer_id: $('#customer_id').val()
    },
    dataType: 'json',
    success: function(response) {
      salesAccountLoading = false;
      
      if (response && response.success && response.accounts && response.accounts.length > 0) {
        // Cache the accounts
        salesAccountCache[currency_id] = response;
        
        // Display the accounts
        displayCachedSalesAccounts(currency_id);
        
        // Auto-select first account with sufficient balance if payment currency matches customer currency
        if (response.customer_currency_id && currency_id == response.customer_currency_id) {
          setTimeout(function() {
            autoSelectCurrencyAccountSales();
          }, 100);
        }
      } else {
        $('#account_id').html('<option value="">No accounts available for this currency</option>');
      }
    },
    error: function() {
      salesAccountLoading = false;
      console.log('Error loading sales accounts');
      $('#account_id').html('<option value="">Error loading accounts</option>');
    }
  });
}

function displayCachedSalesAccounts(currency_id) {
  var response = salesAccountCache[currency_id];
  if (!response || !response.accounts) return;
  
  var options = '<option value="">-Select Account-</option>';
  $.each(response.accounts, function(index, account) {
    var balance = parseFloat(account.balance) || 0;
    var balanceText = balance >= 0 ? 
      ' (Balance: ' + account.currency_symbol + ' ' + balance.toFixed(2) + ')' : 
      ' (Balance: ' + account.currency_symbol + ' ' + balance.toFixed(2) + ')';
    options += '<option value="' + account.id + '" data-balance="' + balance + '" data-currency="' + account.currency_id + '">' + 
              account.account_name + balanceText + '</option>';
  });
  $('#account_id').html(options);
  // Track current currency to prevent reloading
  $('#account_id').data('current-currency', currency_id);
}

function autoSelectCurrencyAccountSales() {
  var customer_id = $('#customer_id').val();
  var payment_currency = $('#payment_currency').val();
  
  if (!customer_id || !payment_currency) return;
  
  console.log('Auto-selecting currency account for customer:', customer_id, 'currency:', payment_currency);
  
  // Get customer currency
  $.ajax({
    url: base_url + 'customers/get_customer_currency',
    type: 'POST',
    data: { customer_id: customer_id },
    dataType: 'json',
    success: function(response) {
      if (response && response.status) {
        var customer_currency_id = response.customer_currency_id;
        
        // Load accounts for customer currency (will use cache if available)
        loadAccountsForPaymentCurrencySales(customer_currency_id);
        
        // Auto-select the account with highest balance after accounts are loaded
        setTimeout(function() {
          var maxBalance = -999999;
          var selectedAccountId = '';
          
          $('#account_id option').each(function() {
            var balance = parseFloat($(this).data('balance')) || 0;
            if (balance > maxBalance) {
              maxBalance = balance;
              selectedAccountId = $(this).val();
            }
          });
          
          if (selectedAccountId) {
            console.log('Auto-selecting sales account:', selectedAccountId, 'with balance:', maxBalance);
            $('#account_id').val(selectedAccountId).trigger('change');
          }
        }, 500); // Reduced timeout since we're using cache
      }
    }
  });
}

function checkAccountBalanceSales() {
  var account_id = $('#account_id').val();
  var payment_amount = parseFloat($('#amount').val()) || 0;
  var payment_currency = $('#payment_currency').val();
  
  if (!account_id) {
    $('#account_balance_display').html('');
    return;
  }
  
  $.ajax({
    url: base_url + 'sales/get_account_balance',
    type: 'POST',
    data: { account_id: account_id },
    dataType: 'json',
    success: function(response) {
      if (response && response.success) {
        var balance = parseFloat(response.balance) || 0;
        var currency_symbol = response.currency_symbol || '$';
        var account_currency = response.currency_id;
        
        // Display balance
        var balanceText = 'Available Balance: ' + currency_symbol + ' ' + balance.toFixed(2);
        var balanceClass = balance >= payment_amount ? 'text-success' : 'text-danger';
        $('#account_balance_display').html('<span class="' + balanceClass + '">' + balanceText + '</span>');
        
        // Check currency mismatch
        if (account_currency != payment_currency) {
          $('#account_currency_alert').show();
        } else {
          $('#account_currency_alert').hide();
        }
        
        // Check sufficient balance
        if (payment_amount > 0 && balance < payment_amount) {
          var shortfall = payment_amount - balance;
          var shortfallText = '<br><span class="text-danger"><i class="fa fa-exclamation-triangle"></i> Insufficient balance. Shortfall: ' + 
                             currency_symbol + ' ' + shortfall.toFixed(2) + '</span>';
          $('#account_balance_display').append(shortfallText);
        }
      } else {
        $('#account_balance_display').html('<span class="text-danger">Error loading account balance</span>');
      }
    },
    error: function() {
      $('#account_balance_display').html('<span class="text-danger">Error loading account balance</span>');
    }
  });
}

function validateAccountCurrencySales() {
  var account_currency = $('#account_id option:selected').data('currency');
  var payment_currency = $('#payment_currency').val();
  
  if (account_currency && payment_currency && account_currency != payment_currency) {
    $('#account_currency_alert').show();
  } else {
    $('#account_currency_alert').hide();
  }
}

function checkPaymentCurrencyExchangeRateSales() {
  var payment_currency = $('#payment_currency').val();
  var base_currency_id = '<?= get_base_currency()->id; ?>';
  
  if (payment_currency && payment_currency != base_currency_id) {
    // Check if exchange rate exists for this currency
    $.ajax({
      url: base_url + 'exchange_rates/check_exchange_rate',
      type: 'POST',
      data: { 
        from_currency_id: payment_currency,
        to_currency_id: base_currency_id
      },
      dataType: 'json',
      success: function(response) {
        if (!response || !response.exists) {
          toastr.warning('Exchange rate not found for this currency. Please add exchange rate in Exchange Rates Management.');
        }
      }
    });
  }
}

// Currency conversion functions for payment modal
function updateCurrencyConversion() {
    var amount = parseFloat($('#amount').val()) || 0;
    var selectedCurrency = $('#payment_currency').val();
    var baseCurrencyId = '<?= get_base_currency()->id; ?>';
    
    if (amount > 0 && selectedCurrency) {
        // Get exchange rate for conversion
        $.ajax({
            url: base_url + 'sales/get_exchange_rate',
            type: 'POST',
            data: { 
                from_currency: selectedCurrency,
                to_currency: baseCurrencyId
            },
            dataType: 'json',
            success: function(res) {
                if (res.status && res.exchange_rate) {
                    var convertedAmount = 0;
                    var conversionText = '';
                    
                    if (selectedCurrency == baseCurrencyId) {
                        // Same currency, no conversion needed
                        conversionText = 'Base currency amount: ' + formatCurrency(amount, res.base_symbol);
                    } else {
                        // Convert to base currency
                        convertedAmount = amount / res.exchange_rate;
                        conversionText = 'Base currency equivalent: ' + formatCurrency(convertedAmount, res.base_symbol) + 
                                       ' (Rate: 1 ' + res.from_code + ' = ' + res.exchange_rate + ' ' + res.base_code + ')';
                    }
                    
                    $('#conversion_text').html(conversionText);
                } else {
                    $('#conversion_text').html('Unable to get exchange rate');
                }
            },
            error: function() {
                $('#conversion_text').html('Error calculating conversion');
            }
        });
    } else {
        $('#conversion_text').html('Enter amount to see conversion');
    }
}

function formatCurrency(amount, symbol) {
    return symbol + ' ' + parseFloat(amount).toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
}  

// Function to clear sales account cache
function clearSalesAccountCache() {
  salesAccountCache = {};
  console.log('Sales account cache cleared');
}

// Make enhanced sales payment functions globally available
window.updatePaymentCurrencySales = updatePaymentCurrencySales;
window.autoSelectCurrencyAccountSales = autoSelectCurrencyAccountSales;
window.checkAccountBalanceSales = checkAccountBalanceSales;
window.validateAccountCurrencySales = validateAccountCurrencySales;
window.checkPaymentCurrencyExchangeRateSales = checkPaymentCurrencyExchangeRateSales;
window.loadAccountsForPaymentCurrencySales = loadAccountsForPaymentCurrencySales;

// ==================== BATCH SELECTION FUNCTIONALITY ====================

// Show batch selection modal for sales
function show_sales_batch_selection_modal(row_id, item_id) {
    console.log('show_sales_batch_selection_modal called with row_id:', row_id, 'item_id:', item_id);
    
    // Get item tracking information from hidden fields
    var batch_tracking_enabled = $('#batch_tracking_enabled_' + row_id).val();
    var tracking_type = $('#tracking_type_' + row_id).val();
    var expiry_enabled = $('#expiry_enabled_' + row_id).val();
    
    console.log('Batch tracking enabled:', batch_tracking_enabled);
    console.log('Tracking type:', tracking_type);
    console.log('Expiry enabled:', expiry_enabled);
    
    if (batch_tracking_enabled == 1) {
        console.log('Opening batch selection modal...');
        
        // Set the item name in modal title
        var item_name = $('#td_data_' + row_id + '_1').text();
        $('#modal_item_name_sales').text(item_name);
        
        // Store current row ID for saving
        window.current_sales_batch_row_id = row_id;
        
        // Load available batches
        load_available_batches(item_id, row_id);
        
        // Show the modal
        $('#sales_batch_selection_modal').modal('show');
        
        console.log('Modal should be showing now');
    } else {
        alert('This item does not have batch tracking enabled.');
    }
}

// Load available batches for an item
function load_available_batches(item_id, row_id) {
    console.log('Loading available batches for item_id:', item_id);
    
    // Get current quantity from the sales form
    var current_qty = parseFloat($('#td_data_' + row_id + '_3').val()) || 1;
    
    $.ajax({
        url: base_url + 'sales/get_available_batches',
        type: 'POST',
        data: { item_id: item_id },
        dataType: 'json',
        success: function(response) {
            console.log('Batch response:', response);
            
            if (response.success && response.batches.length > 0) {
                display_batches(response.batches, row_id);
                $('#no_batches_message').hide();
                $('#batch_selection_table').show();
                
                // Store current quantity for FIFO auto-selection
                window.current_sales_qty = current_qty;
                
                // Show total available stock
                if (response.total_available) {
                    $('#auto_select_fifo_btn').html('<i class="fa fa-magic"></i> Auto-Select FIFO Batches<br><small>Total Available: ' + response.total_available + ' units</small>');
                }
            } else {
                $('#batch_selection_table').hide();
                $('#no_batches_message').show();
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading batches:', error);
            $('#batch_selection_table').hide();
            $('#no_batches_message').show();
        }
    });
}

// Auto-select FIFO batches
function autoSelectFIFO() {
    var row_id = window.current_sales_batch_row_id;
    var item_id = $('#tr_item_id_' + row_id).val();
    var required_qty = window.current_sales_qty || 1;
    
    console.log('Auto-selecting FIFO batches for qty:', required_qty);
    
    $.ajax({
        url: base_url + 'sales/get_recommended_batches',
        type: 'POST',
        data: { 
            item_id: item_id,
            required_qty: required_qty
        },
        dataType: 'json',
        success: function(response) {
            console.log('FIFO recommendation:', response);
            
            if (response.success && response.recommended_batches.length > 0) {
                if (response.can_fulfill) {
                    // Auto-select the recommended batches
                    var total_selected_qty = 0;
                    var batch_details = [];
                    
                    response.recommended_batches.forEach(function(batch) {
                        if (batch.recommended_qty > 0) {
                            total_selected_qty += batch.recommended_qty;
                            batch_details.push({
                                batch_number: batch.batch_number,
                                manufacturing_date: batch.manufacturing_date,
                                expiry_date: batch.expiry_date,
                                qty: batch.recommended_qty
                            });
                        }
                    });
                    
                    // Update the display with selected batches
                    update_batch_display_with_fifo(row_id, batch_details);
                    
                    // Close modal
                    $('#sales_batch_selection_modal').modal('hide');
                    
                    // Show success message
                    showNotification('success', 'FIFO batches selected successfully! Total: ' + total_selected_qty + ' units');
                    
                } else {
                    showNotification('warning', 'Insufficient stock! Available: ' + response.total_available + ', Required: ' + required_qty);
                }
            } else {
                showNotification('error', 'No batches available for FIFO selection');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error getting FIFO recommendations:', error);
            showNotification('error', 'Error getting FIFO recommendations');
        }
    });
}

// Update batch display with FIFO selected batches
function update_batch_display_with_fifo(row_id, batch_details) {
    var batch_display = '';
    
    batch_details.forEach(function(batch, index) {
        if (index > 0) batch_display += '<br>';
        
        batch_display += '<small class="text-info"><strong>Batch ' + (index + 1) + ':</strong> ' + batch.batch_number;
        
        if (batch.manufacturing_date && batch.manufacturing_date !== '0000-00-00') {
            var mfg_parts = batch.manufacturing_date.split('-');
            if (mfg_parts.length === 3 && mfg_parts[0] !== '0000') {
                var mfg_formatted = mfg_parts[2] + '-' + mfg_parts[1] + '-' + mfg_parts[0]; // DD-MM-YYYY
                batch_display += ' (MFG: ' + mfg_formatted + ')';
            }
        }
        
        if (batch.expiry_date && batch.expiry_date !== '0000-00-00') {
            var exp_parts = batch.expiry_date.split('-');
            if (exp_parts.length === 3 && exp_parts[0] !== '0000') {
                var exp_formatted = exp_parts[2] + '-' + exp_parts[1] + '-' + exp_parts[0]; // DD-MM-YYYY
                var days_to_expiry = (new Date(batch.expiry_date) - new Date()) / (1000 * 60 * 60 * 24);
                var expiry_class = days_to_expiry < 0 ? 'text-danger' : (days_to_expiry < 30 ? 'text-warning' : 'text-success');
                batch_display += ' (EXP: ' + exp_formatted + ' - ' + Math.round(days_to_expiry) + ' days)</small>';
            }
        }
        
        batch_display += ' <span class="label label-primary">Qty: ' + batch.qty + '</span>';
    });
    
    // Update the item name cell
    var item_cell = $('#td_' + row_id + '_1 label');
    var current_content = item_cell.html();
    
    // Remove existing batch display
    current_content = current_content.replace(/<br><small class="[^"]*"><strong>(Batch|MFG|EXP):<\/strong>[^<]*<\/small>/g, '');
    
    // Add new batch display
    current_content += '<br>' + batch_display;
    
    item_cell.html(current_content);
    
    // Store batch details in hidden fields (for the first batch)
    if (batch_details.length > 0) {
        var first_batch = batch_details[0];
        $('#batch_number_' + row_id).val(first_batch.batch_number);
        $('#manufacturing_date_' + row_id).val(first_batch.manufacturing_date);
        $('#expiry_date_' + row_id).val(first_batch.expiry_date);
    }
}

// Show notification
function showNotification(type, message) {
    // Create notification element
    var notification = $('<div class="alert alert-' + type + ' alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">' +
        '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
        '<strong>' + (type === 'success' ? 'Success!' : type === 'warning' ? 'Warning!' : 'Error!') + '</strong> ' + message +
        '</div>');
    
    // Add to body
    $('body').append(notification);
    
    // Auto-remove after 5 seconds
    setTimeout(function() {
        notification.fadeOut(function() {
            notification.remove();
        });
    }, 5000);
}

// Display batches in the table
function display_batches(batches, row_id) {
    var tbody = $('#batch_selection_tbody');
    tbody.empty();
    
    batches.forEach(function(batch, index) {
        var mfg_date = '';
        var exp_date = '';
        var days_to_expiry = batch.days_to_expiry;
        
        // Format manufacturing date
        if (batch.manufacturing_date && batch.manufacturing_date !== '0000-00-00') {
            var mfg_parts = batch.manufacturing_date.split('-');
            if (mfg_parts.length === 3 && mfg_parts[0] !== '0000') {
                mfg_date = mfg_parts[2] + '-' + mfg_parts[1] + '-' + mfg_parts[0]; // DD-MM-YYYY
            }
        }
        
        // Format expiry date
        if (batch.expiry_date && batch.expiry_date !== '0000-00-00') {
            var exp_parts = batch.expiry_date.split('-');
            if (exp_parts.length === 3 && exp_parts[0] !== '0000') {
                exp_date = exp_parts[2] + '-' + exp_parts[1] + '-' + exp_parts[0]; // DD-MM-YYYY
            }
        }
        
        // Determine expiry status
        var expiry_class = '';
        var expiry_text = '';
        if (days_to_expiry < 0) {
            expiry_class = 'expiry-critical';
            expiry_text = 'Expired (' + Math.abs(days_to_expiry) + ' days ago)';
        } else if (days_to_expiry < 30) {
            expiry_class = 'expiry-warning';
            expiry_text = days_to_expiry + ' days';
        } else {
            expiry_class = 'expiry-good';
            expiry_text = days_to_expiry + ' days';
        }
        
        // Determine stock status
        var stock_class = '';
        if (batch.available_qty <= 0) {
            stock_class = 'stock-out';
        } else if (batch.available_qty < 5) {
            stock_class = 'stock-low';
        }
        
        var row = '<tr class="batch-row" data-batch-number="' + batch.batch_number + '" data-manufacturing-date="' + batch.manufacturing_date + '" data-expiry-date="' + batch.expiry_date + '">' +
            '<td><strong>' + batch.batch_number + '</strong></td>' +
            '<td>' + mfg_date + '</td>' +
            '<td>' + exp_date + '</td>' +
            '<td><span class="' + expiry_class + '">' + expiry_text + '</span></td>' +
            '<td><span class="' + stock_class + '">' + batch.available_qty + '</span></td>' +
            '<td><button type="button" class="btn btn-success btn-sm" onclick="select_batch(' + row_id + ', \'' + batch.batch_number + '\', \'' + batch.manufacturing_date + '\', \'' + batch.expiry_date + '\')">Select</button></td>' +
            '</tr>';
        
        tbody.append(row);
    });
}

// Select a batch and close modal
function select_batch(row_id, batch_number, manufacturing_date, expiry_date) {
    console.log('Selecting batch:', batch_number, 'for row:', row_id);
    
    // Update hidden fields
    $('#batch_number_' + row_id).val(batch_number);
    $('#manufacturing_date_' + row_id).val(manufacturing_date);
    $('#expiry_date_' + row_id).val(expiry_date);
    
    // Update display in the item row
    update_batch_display(row_id, batch_number, manufacturing_date, expiry_date);
    
    // Close modal
    $('#sales_batch_selection_modal').modal('hide');
    
    console.log('Batch selected successfully');
}

// Update batch display in the item row
function update_batch_display(row_id, batch_number, manufacturing_date, expiry_date) {
    var batch_display = '';
    
    if (batch_number) {
        batch_display += '<br><small class="text-info"><strong>Batch:</strong> ' + batch_number + '</small>';
    }
    
    if (manufacturing_date && manufacturing_date !== '0000-00-00') {
        var mfg_parts = manufacturing_date.split('-');
        if (mfg_parts.length === 3 && mfg_parts[0] !== '0000') {
            var mfg_formatted = mfg_parts[2] + '-' + mfg_parts[1] + '-' + mfg_parts[0]; // DD-MM-YYYY
            batch_display += '<br><small class="text-info"><strong>MFG:</strong> ' + mfg_formatted + '</small>';
        }
    }
    
    if (expiry_date && expiry_date !== '0000-00-00') {
        var exp_parts = expiry_date.split('-');
        if (exp_parts.length === 3 && exp_parts[0] !== '0000') {
            var exp_formatted = exp_parts[2] + '-' + exp_parts[1] + '-' + exp_parts[0]; // DD-MM-YYYY
            var days_to_expiry = (new Date(expiry_date) - new Date()) / (1000 * 60 * 60 * 24);
            var expiry_class = days_to_expiry < 0 ? 'text-danger' : (days_to_expiry < 30 ? 'text-warning' : 'text-success');
            batch_display += '<br><small class="' + expiry_class + '"><strong>EXP:</strong> ' + exp_formatted + ' (' + Math.round(days_to_expiry) + ' days)</small>';
        }
    }
    
    // Update the item name cell
    var item_cell = $('#td_' + row_id + '_1 label');
    var current_content = item_cell.html();
    
    // Remove existing batch display
    current_content = current_content.replace(/<br><small class="[^"]*"><strong>(Batch|MFG|EXP):<\/strong>[^<]*<\/small>/g, '');
    
    // Add new batch display
    current_content += batch_display;
    
    item_cell.html(current_content);
}
window.clearSalesAccountCache = clearSalesAccountCache;  